/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.samples.shell.components.LineBevel;
import com.jniwrapper.win32.io.FileSystem;
import com.jniwrapper.win32.shell.ShellIcon;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FileSystemInfoSample
extends LazyPanel {
    private static final String[] HEADER = new String[]{"", "Type", "Total Size", "Free Space", "Serial No."};
    private JLabel lblAdvisoryText;
    private JPanel _hardDrivesList;
    private JButton btnUpdate;

    public FileSystemInfoSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        this.lblAdvisoryText = new HTMLText("This page demonstrates FileSystem class features to retrieve file system information.");
        this._hardDrivesList = new JPanel(new GridBagLayout());
        this.updateHardDrivesList();
        JLabel lblCaption = new JLabel("File System Information");
        LineBevel bevel = new LineBevel();
        this.btnUpdate = new JButton(new AbstractAction("Update"){

            public void actionPerformed(ActionEvent e) {
                FileSystemInfoSample.this.updateHardDrivesList();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 15, 10), 0, 0));
        this.add((Component)lblCaption, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)bevel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 10, 10), 0, 0));
        this.add((Component)this._hardDrivesList, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.btnUpdate, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        super.initialize();
    }

    private void updateHardDrivesList() {
        int i;
        this._hardDrivesList.removeAll();
        File[] roots = File.listRoots();
        for (i = 0; i < HEADER.length; ++i) {
            this._hardDrivesList.add((Component)new JLabel("<html><b><nobr>" + HEADER[i] + "</nobr></b></html>"), new GridBagConstraints(i, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 10), 0, 0));
        }
        for (i = 0; i < roots.length; ++i) {
            ShellIcon icon = new ShellIcon(roots[i]);
            String label = FileSystem.getVolumeLabel((File)roots[i]);
            String driveName = roots[i].getAbsolutePath();
            String volumeType = this.getVolumeType(FileSystem.getDriveType((File)roots[i]));
            String totalSpace = this.formatBytes(FileSystem.getDiskTotalSize((File)roots[i]));
            String freeSpace = this.formatBytes(FileSystem.getDiskFreeSpace((File)roots[i]));
            String serialNumber = Long.toString(FileSystem.getSerialNumber((File)roots[i]));
            JLabel lblDrive = new JLabel(label + " (" + driveName + ")", new ImageIcon(icon.toImage()), 2);
            this._hardDrivesList.add((Component)lblDrive, new GridBagConstraints(0, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 20), 0, 0));
            this._hardDrivesList.add((Component)new JLabel(volumeType), new GridBagConstraints(1, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
            this._hardDrivesList.add((Component)new JLabel(totalSpace), new GridBagConstraints(2, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
            this._hardDrivesList.add((Component)new JLabel(freeSpace), new GridBagConstraints(3, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
            this._hardDrivesList.add((Component)new JLabel(serialNumber), new GridBagConstraints(4, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        }
        this._hardDrivesList.revalidate();
    }

    private String getVolumeType(FileSystem.DriveType driveType) {
        if (driveType.equals((Object)FileSystem.DriveType.CDROM)) {
            return "CD-ROM";
        }
        if (driveType.equals((Object)FileSystem.DriveType.FIXED)) {
            return "Local Disk";
        }
        if (driveType.equals((Object)FileSystem.DriveType.RAMDISK)) {
            return "RAM Disk";
        }
        if (driveType.equals((Object)FileSystem.DriveType.REMOTE)) {
            return "Remote Drive";
        }
        if (driveType.equals((Object)FileSystem.DriveType.REMOVABLE)) {
            return "Removable Drive";
        }
        return "Unknown";
    }

    private String formatBytes(long value) {
        int i = 0;
        while (true) {
            double result;
            if ((result = (double)value / Math.pow(2.0, 10 * i)) < 1000.0 || i == 3) {
                StringBuffer buffer = new StringBuffer();
                DecimalFormat decimalFormat = new DecimalFormat("0.#");
                buffer = decimalFormat.format(result, buffer, new FieldPosition(1));
                switch (i) {
                    case 0: {
                        buffer.append(" Bytes");
                        break;
                    }
                    case 1: {
                        buffer.append(" KBytes");
                        break;
                    }
                    case 2: {
                        buffer.append(" MBytes");
                        break;
                    }
                    default: {
                        buffer.append(" GBytes");
                    }
                }
                return buffer.toString();
            }
            ++i;
        }
    }
}

