/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LineBevel;
import com.jniwrapper.win32.samples.demo.ComfyJSample;
import com.jniwrapper.win32.shell.FolderIcon;
import com.jniwrapper.win32.system.VersionInfo;
import com.jniwrapper.win32.ui.controls.ChooseIconField;
import com.jniwrapper.win32.ui.controls.SelectFolderField;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class FolderCustomizationSample
extends ComfyJSample
implements PropertyChangeListener {
    private JLabel lblAdvisoryText;
    private SelectFolderField _selectFolderField;
    private JLabel lblSelectFolderCaption;
    private JLabel lblChooseIconCaption;
    private ChooseIconField _chooseIconField;
    private JLabel lblSelectedFileCaption;
    private JTextField txtSelectedFile;
    private JLabel lblSelectedIndexCaption;
    private JLabel lblSelectedIndex;
    private JButton btnApplyChanges;
    private JButton btnRestoreDefault;
    private JLabel lblFolderInfoTipCaption;
    private JTextField txtFolderInfoTip;
    private JLabel lblNotsupported;

    public FolderCustomizationSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        boolean comfyjAvailable = this.isComfyJAvailable();
        this.lblNotsupported = comfyjAvailable ? new JLabel() : new HTMLText("<b><FONT color = red>NOTE:</FONT> The folder customization functionality requires the ComfyJ library and ComfyJ license file.");
        VersionInfo versionInfo = new VersionInfo();
        boolean isWinXP = false;
        boolean isVista = false;
        if (versionInfo.getMajor() == 5L && versionInfo.getMinor() >= 1L) {
            isWinXP = true;
        }
        if (versionInfo.getMajor() > 5L) {
            isVista = true;
        }
        this.lblAdvisoryText = new HTMLText("The page demonstrates WinPack ability to customize folder icon and info tip.", false);
        this._selectFolderField = new SelectFolderField();
        this._selectFolderField.addPropertyChangeListener("folder", (PropertyChangeListener)this);
        if (!isWinXP || !comfyjAvailable) {
            this._selectFolderField.setEnabled(false);
        }
        this.lblSelectFolderCaption = new JLabel("Select Folder:");
        this.lblChooseIconCaption = new JLabel("Choose Folder Icon:");
        this._chooseIconField = new ChooseIconField();
        this._chooseIconField.addPropertyChangeListener("icon", (PropertyChangeListener)this);
        this._chooseIconField.setEnabled(false);
        this.lblSelectedFileCaption = new JLabel("Selected Icon File: ");
        this.txtSelectedFile = new JTextField(30);
        this.txtSelectedFile.setEditable(false);
        this.txtSelectedFile.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.txtSelectedFile.setBackground(this.getBackground());
        this.txtSelectedFile.setText("No Icon Selected");
        this.lblSelectedIndexCaption = new JLabel("Selected Icon Index: ");
        this.lblSelectedIndex = new JLabel();
        this.lblSelectedIndex.setText("No Icon Selected");
        this.lblFolderInfoTipCaption = new JLabel("Folder Info Tip: ");
        this.txtFolderInfoTip = new JTextField(30);
        this.txtFolderInfoTip.setEnabled(false);
        this.btnApplyChanges = new JButton("Apply Changes");
        this.btnApplyChanges.setEnabled(false);
        this.btnApplyChanges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File folder = new File(FolderCustomizationSample.this._selectFolderField.getFolder());
                File iconFile = FolderCustomizationSample.this._chooseIconField.getIconFile();
                int iconIndex = FolderCustomizationSample.this._chooseIconField.getIconIndex();
                String infoTip = FolderCustomizationSample.this.txtFolderInfoTip.getText();
                try {
                    FolderIcon.setFolderIcon((File)folder, (File)iconFile, (int)iconIndex, (String)infoTip);
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
        });
        this.btnRestoreDefault = new JButton("Restore Default");
        this.btnRestoreDefault.setEnabled(false);
        this.btnRestoreDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File folder = new File(FolderCustomizationSample.this._selectFolderField.getFolder());
                try {
                    FolderIcon.restoreDefaultFolderIcon((File)folder);
                    FolderCustomizationSample.this.resetDisplayElements();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        if (comfyjAvailable && !isWinXP && !isVista) {
            this.lblNotsupported = new HTMLText("<b><FONT color = red>NOTE:</FONT> Folder customization feature is not supported by current version of operation system.");
        }
        if (comfyjAvailable && !isWinXP && isVista) {
            this.lblNotsupported = new HTMLText("<b><FONT color = red>NOTE:</FONT> Under MS Vista folder customization API is changed therefore this feature is not available.");
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.lblSelectFolderCaption, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.add((Component)this._selectFolderField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        LineBevel bevel1 = new LineBevel();
        this.add((Component)bevel1, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 13, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.lblFolderInfoTipCaption, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.txtFolderInfoTip, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lblChooseIconCaption, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this._chooseIconField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lblSelectedFileCaption, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.txtSelectedFile, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lblSelectedIndexCaption, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lblSelectedIndex, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.btnApplyChanges);
        buttonPanel.add(this.btnRestoreDefault);
        this.add((Component)buttonPanel, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lblNotsupported, new GridBagConstraints(0, 9, 3, 1, 0.0, 0.0, 17, 2, new Insets(15, 10, 0, 0), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 10, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        super.initialize();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("icon")) {
            this.txtSelectedFile.setText(this._chooseIconField.getIconFile().getAbsolutePath());
            this.lblSelectedIndex.setText(Integer.toString(this._chooseIconField.getIconIndex()));
        } else {
            this.txtFolderInfoTip.setEnabled(true);
            this._chooseIconField.setEnabled(true);
            this.btnApplyChanges.setEnabled(true);
            this.btnRestoreDefault.setEnabled(true);
            this.resetDisplayElements();
        }
    }

    private void resetDisplayElements() {
        FolderIcon folderIcon = FolderIcon.getFolderIcon((File)new File(this._selectFolderField.getFolder()));
        this.txtFolderInfoTip.setText(folderIcon.getInfoTip());
        this._chooseIconField.setIconImage(folderIcon.getIconFile(), folderIcon.getIconIndex());
        this.txtSelectedFile.setText(folderIcon.getIconFile().getAbsolutePath());
        this.lblSelectedIndex.setText(Integer.toString(folderIcon.getIconIndex()));
    }
}

