/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.win32.ui.controls.SelectFileField;
import com.jniwrapper.win32.ui.dialogs.OpenSaveFileDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class OpenSaveFileSample
extends LazyPanel
implements PropertyChangeListener {
    private Vector _files;
    private JLabel lblAdvisoryText;
    private JLabel lblFileNameCaption;
    private SelectFileField _selectFileField;
    private JLabel lblSelectedFiles;
    private JLabel lblNote;
    private JList lstSelectedFiles;
    private JCheckBox cbAllowMultipleSelection;
    private JCheckBox cbShowExplorer;
    private JCheckBox cbShowHelp;
    private JCheckBox cbShowHiddenFiles;
    private JCheckBox cbEnableSizing;
    private JCheckBox cbHideReadOnly;
    JPanel _optionsPanel;
    OpenSaveFileDialog.OpenSaveFileDialogOptions _options;

    public OpenSaveFileSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        this._files = new Vector();
        this.lblAdvisoryText = new HTMLText("This page demonstrates a standard Open/Save File dialog which is invoked using a special SelectFileField control. Use the options below to modify the behavior of the dialog.");
        this.lblFileNameCaption = new JLabel("Select File:");
        this._selectFileField = new SelectFileField();
        this._selectFileField.getDialog().setOwner(this.getParentWindow());
        this.lblSelectedFiles = new JLabel("Selected Files:");
        this.lblNote = new HTMLText("<b>NOTE:</b> Multiple files selected in the dialog are shown in the text box above.");
        this.lstSelectedFiles = new JList(this._files);
        this._selectFileField.addPropertyChangeListener("file", (PropertyChangeListener)this);
        this._selectFileField.getDialog().getOptions().setMultiselectionAllowed(true);
        this._selectFileField.getDialog().setFilter("All Files (*.*)|*.*|Pictures|*.bmp;*.gif;*.jpeg");
        this._options = this._selectFileField.getDialog().getOptions();
        this.cbAllowMultipleSelection = new JCheckBox("Allow multiple selection", this._options.isMultiselectionAllowed());
        this.cbAllowMultipleSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                OpenSaveFileSample.this._options.setMultiselectionAllowed(checkBox.isSelected());
            }
        });
        this.cbEnableSizing = new JCheckBox("Enable sizing", this._options.isSizingEnabled());
        this.cbEnableSizing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                OpenSaveFileSample.this._options.setSizingEnabled(checkBox.isSelected());
            }
        });
        this.cbHideReadOnly = new JCheckBox("Hide read-only files", this._options.isHideReadOnly());
        this.cbHideReadOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                OpenSaveFileSample.this._options.setHideReadOnly(checkBox.isSelected());
            }
        });
        this.cbShowExplorer = new JCheckBox("Use Explorer style", this._options.isShowExplorer());
        this.cbShowExplorer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                OpenSaveFileSample.this._options.setShowExplorer(checkBox.isSelected());
                if (!checkBox.isSelected()) {
                    OpenSaveFileSample.this.cbEnableSizing.setSelected(checkBox.isSelected());
                    OpenSaveFileSample.this._options.setSizingEnabled(OpenSaveFileSample.this.cbEnableSizing.isSelected());
                }
                OpenSaveFileSample.this.cbEnableSizing.setEnabled(checkBox.isSelected());
            }
        });
        this.cbShowHelp = new JCheckBox("Show Help button", this._options.isShowHelp());
        this.cbShowHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                OpenSaveFileSample.this._options.setShowHelp(checkBox.isSelected());
            }
        });
        this.cbShowHiddenFiles = new JCheckBox("Show hidden files", this._options.isShowHiddenFiles());
        this.cbShowHiddenFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                OpenSaveFileSample.this._options.setShowHiddenFiles(checkBox.isSelected());
            }
        });
        this._optionsPanel = new JPanel(new GridLayout(3, 2));
        this._optionsPanel.add(this.cbAllowMultipleSelection);
        this._optionsPanel.add(this.cbShowHelp);
        this._optionsPanel.add(this.cbHideReadOnly);
        this._optionsPanel.add(this.cbShowExplorer);
        this._optionsPanel.add(this.cbEnableSizing);
        this._optionsPanel.add(this.cbShowHiddenFiles);
        JScrollPane files = new JScrollPane(this.lstSelectedFiles);
        files.setPreferredSize(new Dimension(10, 100));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._optionsPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.lblFileNameCaption, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this._selectFileField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lblSelectedFiles, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)files, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.5, 17, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.lblNote, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        super.initialize();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this._files.clear();
        this._files.addAll(this._selectFileField.getDialog().getFiles());
        this.lstSelectedFiles.updateUI();
    }
}

