/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.process.CurrentProcess;
import com.jniwrapper.win32.process.Process;
import com.jniwrapper.win32.process.Psapi;
import com.jniwrapper.win32.process.monitoring.ModuleEntry;
import com.jniwrapper.win32.process.monitoring.ProcessEntry;
import com.jniwrapper.win32.process.monitoring.Snapshot;
import com.jniwrapper.win32.system.VersionInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ProcessMonitoringSample
extends LazyPanel {
    private JLabel lblAdvisoryText;
    private JLabel lblRunningModules;
    private JTable _runningModules;
    private JLabel lblRunningProcesses;
    private JTable _runningProcesses;
    private JButton _updateInfo;
    private ModulesTableModel _modulesTableModel;
    private ProcessesTableModel _processesTableModel;
    private JLabel lblNotSupported;
    private Snapshot _snapshot;
    private boolean _isWinNT;
    private boolean _disabled;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;

    public ProcessMonitoringSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        VersionInfo versionInfo = new VersionInfo();
        this._isWinNT = false;
        this._disabled = false;
        if (versionInfo.isNT() && versionInfo.getMajor() <= 4L) {
            this._isWinNT = true;
        }
        try {
            Psapi.getInstance().getFunction("EnumProcesses");
        }
        catch (Throwable e) {
            this._disabled = true;
        }
        this.lblAdvisoryText = new HTMLText("The page demonstrates the WinPack ability to monitor running modules and processes, using the Processes API. Press the \"Update\" button to update the snapshot.");
        this.lblNotSupported = new HTMLText("<b><FONT color = red>NOTE:</FONT> This functionality is not supported by current version of operation system.</b>");
        if (!this._isWinNT) {
            Snapshot.Options options = new Snapshot.Options(true);
            this._snapshot = new Snapshot(options);
        }
        if (!this._disabled) {
            this.lblRunningModules = new JLabel("Running Modules of the Current Process:");
            this.lblRunningProcesses = new JLabel("Running Processes:");
            this._modulesTableModel = new ModulesTableModel();
            this._runningModules = new JTable(this._modulesTableModel){

                public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                }
            };
            this._runningModules.setSelectionMode(0);
            this._runningModules.setRowSelectionAllowed(true);
            this._runningModules.setShowHorizontalLines(false);
            this._runningModules.setShowVerticalLines(false);
            TableColumnModel columnModel = this._runningModules.getColumnModel();
            columnModel.getColumn(0).setPreferredWidth(30);
            columnModel.getColumn(1).setPreferredWidth(200);
            TableColumn emptyColumn1 = columnModel.getColumn(2);
            emptyColumn1.setPreferredWidth(5);
            emptyColumn1.setMaxWidth(5);
            emptyColumn1.setMinWidth(5);
            JScrollPane runningModules = new JScrollPane(this._runningModules);
            this._processesTableModel = new ProcessesTableModel();
            this._runningProcesses = new JTable(this._processesTableModel){

                public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                }
            };
            this._runningProcesses.setSelectionMode(0);
            this._runningProcesses.setRowSelectionAllowed(true);
            this._runningProcesses.setShowHorizontalLines(false);
            this._runningProcesses.setShowVerticalLines(false);
            TableColumnModel columnModel2 = this._runningProcesses.getColumnModel();
            columnModel2.getColumn(0).setPreferredWidth(200);
            columnModel2.getColumn(1).setPreferredWidth(50);
            TableColumn emptyColumn2 = columnModel2.getColumn(2);
            emptyColumn2.setPreferredWidth(5);
            emptyColumn2.setMaxWidth(5);
            emptyColumn2.setMinWidth(5);
            JScrollPane runningProcesses = new JScrollPane(this._runningProcesses);
            this._updateInfo = new JButton("Update");
            this._updateInfo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProcessMonitoringSample.this.update();
                }
            });
            this.setLayout(new GridBagLayout());
            this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
            this.add((Component)this.lblRunningProcesses, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
            this.add((Component)runningProcesses, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.add((Component)this.lblRunningModules, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
            this.add((Component)runningModules, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 15, 10), 0, 0));
            this.add((Component)this._updateInfo, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 5, 10), 0, 0));
        } else {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
            this.add((Component)this.lblNotSupported, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 10, 0, 10), 0, 0));
            this.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        super.initialize();
    }

    private void update() {
        if (!this._isWinNT) {
            this._snapshot.run();
        }
        this._modulesTableModel.fireTableDataChanged();
        this._processesTableModel.fireTableDataChanged();
    }

    public void activate() throws Exception {
        super.activate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProcessMonitoringSample.this.update();
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ModulesTableModel
    extends AbstractTableModel {
        List _entries = null;

        public ModulesTableModel() {
            this.fireTableDataChanged();
        }

        public void fireTableDataChanged() {
            if (this._entries != null) {
                this._entries.clear();
                this._entries = null;
            }
            if (!ProcessMonitoringSample.this._isWinNT) {
                this._entries = ProcessMonitoringSample.this._snapshot.getModules();
            } else {
                CurrentProcess process = new CurrentProcess();
                this._entries = process.getModules();
            }
            super.fireTableDataChanged();
        }

        public int getRowCount() {
            return this._entries.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Module Name";
                }
                case 1: {
                    return "Executable Path";
                }
                case 2: {
                    return "";
                }
            }
            return null;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (!ProcessMonitoringSample.this._isWinNT) {
                ModuleEntry moduleEntry = (ModuleEntry)this._entries.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return moduleEntry.getModuleName();
                    }
                    case 1: {
                        return moduleEntry.getExePath();
                    }
                    case 2: {
                        return "";
                    }
                }
            } else {
                CurrentProcess process = new CurrentProcess();
                String module = process.getModuleFileName((Handle)this._entries.get(rowIndex));
                switch (columnIndex) {
                    case 0: {
                        return module.substring(module.lastIndexOf("\\") + 1, module.length());
                    }
                    case 1: {
                        return module;
                    }
                    case 2: {
                        return "";
                    }
                }
            }
            return null;
        }
    }

    private class ProcessesTableModel
    extends AbstractTableModel {
        List _entries = null;

        public ProcessesTableModel() {
            this.fireTableDataChanged();
        }

        public void fireTableDataChanged() {
            if (this._entries != null) {
                this._entries.clear();
                this._entries = null;
            }
            this._entries = !ProcessMonitoringSample.this._isWinNT ? ProcessMonitoringSample.this._snapshot.getProcesses() : Process.getProcesses();
            super.fireTableDataChanged();
        }

        public int getRowCount() {
            return this._entries.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Executable File";
                }
                case 1: {
                    return "Process ID";
                }
                case 2: {
                    return "";
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return class$java$lang$String == null ? (class$java$lang$String = ProcessMonitoringSample.class$("java.lang.String")) : class$java$lang$String;
                }
                case 1: {
                    return class$java$lang$Long == null ? (class$java$lang$Long = ProcessMonitoringSample.class$("java.lang.Long")) : class$java$lang$Long;
                }
                case 2: {
                    return class$java$lang$String == null ? (class$java$lang$String = ProcessMonitoringSample.class$("java.lang.String")) : class$java$lang$String;
                }
            }
            return null;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (!ProcessMonitoringSample.this._isWinNT) {
                ProcessEntry processEntry = (ProcessEntry)this._entries.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return processEntry.getExeFile();
                    }
                    case 1: {
                        return new Long(processEntry.getProcessID());
                    }
                    case 2: {
                        return "";
                    }
                }
            } else {
                Process process = (Process)this._entries.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        String fileName = process.getProcessFileName();
                        if (fileName != null) {
                            return fileName.substring(fileName.lastIndexOf("\\") + 1, fileName.length());
                        }
                        return "";
                    }
                    case 1: {
                        return new Long(process.getProcessID());
                    }
                    case 2: {
                        return "";
                    }
                }
            }
            return null;
        }
    }
}

