/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.NoSuchFunctionException;
import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.win32.service.Service;
import com.jniwrapper.win32.service.ServiceManager;
import com.jniwrapper.win32.system.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ServicesSample
extends LazyPanel {
    private static final Vector COLUMN_NAMES = new Vector();
    private static final String DOMAIN_SEPARATOR = "\\";
    private JLabel lblAdvisoryText;
    private Vector _servicesInfo = new Vector();
    private JTable _servicesTable;
    private boolean _isWinNT;
    private JLabel lblNotSupported;
    private JPanel servicesPanel;
    private JPanel updatePanel;

    public ServicesSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        VersionInfo versionInfo = new VersionInfo();
        this._isWinNT = false;
        if (versionInfo.isNT()) {
            this._isWinNT = true;
        }
        DefaultTableModel tableModel = new DefaultTableModel(this._servicesInfo, COLUMN_NAMES){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.servicesPanel = new JPanel();
        this.servicesPanel.setLayout(new BorderLayout());
        this._servicesTable = new JTable(tableModel);
        this._servicesTable.setSelectionMode(0);
        this._servicesTable.setRowSelectionAllowed(true);
        this._servicesTable.setShowHorizontalLines(false);
        this._servicesTable.setShowVerticalLines(false);
        TableColumnModel columnModel = this._servicesTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(70);
        columnModel.getColumn(1).setPreferredWidth(200);
        columnModel.getColumn(2).setPreferredWidth(30);
        columnModel.getColumn(3).setPreferredWidth(50);
        TableColumn emptyColumn = columnModel.getColumn(4);
        emptyColumn.setPreferredWidth(4);
        emptyColumn.setMaxWidth(4);
        emptyColumn.setMinWidth(4);
        if (!this._isWinNT) {
            this.lblNotSupported = new HTMLText("<b><FONT color = red>NOTE:</FONT> Service management functionality is not supported by current version of operation system.");
            this.lblNotSupported.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        } else {
            this.lblNotSupported = new JLabel();
        }
        this.setLayout(new BorderLayout());
        this.servicesPanel.add((Component)this._servicesTable.getTableHeader(), "North");
        this.servicesPanel.add((Component)new JScrollPane(this._servicesTable), "Center");
        this.lblAdvisoryText = new HTMLText("The page demonstrates the WinPack ability to manage NT Services, using the Services API.<br>Press the \"Update\" button to update the list.");
        this.lblAdvisoryText.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.servicesPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JButton updateButton = new JButton("Update");
        if (!this._isWinNT) {
            updateButton.setEnabled(false);
        }
        updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServicesSample.this.loadServicesInfo();
            }
        });
        this.updatePanel = new JPanel();
        this.updatePanel.add(updateButton);
        this.add((Component)this.lblAdvisoryText, "North");
        if (this._isWinNT) {
            this.add((Component)this.servicesPanel, "Center");
            this.add((Component)this.updatePanel, "South");
        } else {
            this.add((Component)this.lblNotSupported, "Center");
        }
        super.initialize();
    }

    public void activate() throws Exception {
        super.activate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ServicesSample.this.loadServicesInfo();
            }
        });
    }

    private void loadServicesInfo() {
        if (this._isWinNT) {
            try {
                ServiceManager serviceManager = new ServiceManager();
                this.loadServicesInfo(serviceManager);
            }
            catch (Exception ex) {
                this.remove(this.servicesPanel);
                this.lblAdvisoryText.setText("The page demonstrates the WinPack ability to manage NT Services, using the Services API.<br>Press the \"Update\" button to update the list.<br><br>&nbsp;<b><FONT color = red>NOTE:</FONT> You should have Administrator rights to have the services displayed.</b>");
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadServicesInfo(ServiceManager serviceManager) {
        this._servicesInfo.clear();
        Service[] services = serviceManager.getServices();
        for (int i = 0; i < services.length; ++i) {
            Service service = services[i];
            try {
                Vector<String> row = new Vector<String>(5);
                row.add(service.getDisplayName());
                try {
                    row.add(this.getDescription(service));
                    row.add(this.getStatus(service));
                    row.add(this.getStartupType(service));
                    row.add("");
                }
                finally {
                    service.close();
                }
                this._servicesInfo.add(row);
                continue;
            }
            catch (Exception e) {
                System.out.println("failed for " + service.getName());
            }
        }
        ((AbstractTableModel)this._servicesTable.getModel()).fireTableDataChanged();
    }

    private String getDescription(Service service) {
        String description = null;
        try {
            description = service.getDescription();
        }
        catch (NoSuchFunctionException e) {
            description = "";
        }
        return description;
    }

    private String getStatus(Service service) {
        return service.getCurrentState().toString();
    }

    private String getStartupType(Service service) {
        return service.getStartupType().toString();
    }

    static {
        COLUMN_NAMES.add("Name");
        COLUMN_NAMES.add("Description");
        COLUMN_NAMES.add("Status");
        COLUMN_NAMES.add("Startup Type");
        COLUMN_NAMES.add("");
    }
}

