/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.samples.shell.components.LineBevel;
import com.jniwrapper.util.ProcessorInfo;
import com.jniwrapper.win32.system.MemoryInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SystemInfoSample
extends LazyPanel {
    private JLabel lblAdvisoryText;
    private JLabel lblProcessorInformation;
    private JLabel lblVendorCaption;
    private JLabel lblVendor;
    private JLabel lblProcessorNameCaption;
    private JLabel lblProcessorName;
    private JLabel lblFrequencyCaption;
    private JLabel lblFrequency;
    private JLabel lblFamilyCaption;
    private JLabel lblFamily;
    private JLabel lblModelCaption;
    private JLabel lblModel;
    private JLabel lblSteppingCaption;
    private JLabel lblStepping;
    private JCheckBox chkFPU;
    private JCheckBox chkMMX;
    private JCheckBox chkMMXPlus;
    private JCheckBox chk3DNow;
    private JCheckBox chk3DNowPlus;
    private JCheckBox chkSSE;
    private JCheckBox chkSSE2;
    private JCheckBox chkSSE3;
    private JCheckBox chkEM64T;
    private JCheckBox chkAMD64;
    private JLabel lblMemoryInformationCaption;
    private JLabel lblPhisicalTotalCaption;
    private JLabel lblPhisicalAvailableCaption;
    private JLabel lblPhisicalTotal;
    private JLabel lblPhisicalAvailable;

    public SystemInfoSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        ProcessorInfo info = ProcessorInfo.getInstance();
        this.lblAdvisoryText = new HTMLText("This page displays information about your processor using ProcessorInfo class and memory information using MemoryStatus class.");
        this.lblProcessorInformation = new JLabel("Processor Information:");
        this.lblVendorCaption = new JLabel("Vendor:");
        this.lblVendor = new JLabel(info.getVendor());
        this.lblProcessorNameCaption = new JLabel("Processor Name:");
        this.lblProcessorName = new JLabel(info.getProcessorName());
        this.lblFrequencyCaption = new JLabel("Frequency:");
        this.lblFrequency = new JLabel(String.valueOf(info.getFrequency()) + " MHz");
        this.lblFamilyCaption = new JLabel("Family:");
        this.lblFamily = new JLabel(String.valueOf(info.getFamily()));
        this.lblModelCaption = new JLabel("Model:");
        this.lblModel = new JLabel(String.valueOf(info.getModel()));
        this.lblSteppingCaption = new JLabel("Stepping:");
        this.lblStepping = new JLabel(String.valueOf(info.getStepping()));
        this.chkFPU = new CPUFeature("FPU", info.hasFPU());
        this.chkMMX = new CPUFeature("MMX", info.hasMMX());
        this.chkMMXPlus = new CPUFeature("MMXPlus", info.hasMMXPlus());
        this.chk3DNow = new CPUFeature("3DNow!", info.has3DNow());
        this.chk3DNowPlus = new CPUFeature("3DNow! Plus", info.has3DNowPlus());
        this.chkSSE = new CPUFeature("SSE", info.hasSSE());
        this.chkSSE2 = new CPUFeature("SSE2", info.hasSSE2());
        this.chkSSE3 = new CPUFeature("SSE3", info.hasSSE3());
        this.chkEM64T = new CPUFeature("EM64T", info.hasEM64T());
        this.chkAMD64 = new CPUFeature("AMD64", info.hasAMD64());
        this.lblMemoryInformationCaption = new JLabel("Memory Information:");
        this.lblPhisicalTotalCaption = new JLabel("Physical Total:");
        this.lblPhisicalTotal = new JLabel();
        this.lblPhisicalAvailableCaption = new JLabel("Physical Available:");
        this.lblPhisicalAvailable = new JLabel();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.lblProcessorInformation, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
        LineBevel bevel1 = new LineBevel();
        this.add((Component)bevel1, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 13, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.lblVendorCaption, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 10), 0, 0));
        this.add((Component)this.lblVendor, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.lblProcessorNameCaption, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.lblProcessorName, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.lblFrequencyCaption, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.lblFrequency, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.lblFamilyCaption, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.lblFamily, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.lblModelCaption, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.lblModel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.lblSteppingCaption, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.lblStepping, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.chkFPU, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 10), 0, 0));
        this.add((Component)this.chkMMX, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 10), 0, 0));
        this.add((Component)this.chkMMXPlus, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 10), 0, 0));
        this.add((Component)this.chk3DNow, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 10), 0, 0));
        this.add((Component)this.chk3DNowPlus, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 10), 0, 0));
        this.add((Component)this.chkAMD64, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 10), 0, 0));
        this.add((Component)this.chkSSE, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 10), 0, 0));
        this.add((Component)this.chkSSE2, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 10), 0, 0));
        this.add((Component)this.chkSSE3, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 10), 0, 0));
        this.add((Component)this.chkEM64T, new GridBagConstraints(3, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 10), 0, 0));
        this.add((Component)this.lblMemoryInformationCaption, new GridBagConstraints(0, 11, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        LineBevel bevel2 = new LineBevel();
        this.add((Component)bevel2, new GridBagConstraints(1, 11, 3, 1, 0.0, 0.0, 13, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.lblPhisicalTotalCaption, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 10), 0, 0));
        this.add((Component)this.lblPhisicalTotal, new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.lblPhisicalAvailableCaption, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)this.lblPhisicalAvailable, new GridBagConstraints(1, 13, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 14, 4, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        super.initialize();
    }

    public void activate() throws Exception {
        super.activate();
        MemoryInfo memoryInfo = new MemoryInfo();
        this.lblPhisicalTotal.setText("" + memoryInfo.getTotalPhys() / 1024L + " Kb");
        this.lblPhisicalAvailable.setText("" + memoryInfo.getAvailPhys() / 1024L + " Kb");
    }

    private class CPUFeature
    extends JCheckBox {
        public CPUFeature(String text, boolean selected) {
            super(text, selected);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setFocusPainted(false);
            this.setSelectedIcon(new ImageIcon(this.getClass().getResource("res/checked.gif")));
            this.setIcon(new ImageIcon(this.getClass().getResource("res/unchecked.gif")));
        }

        protected void processMouseEvent(MouseEvent e) {
        }

        protected void processKeyEvent(KeyEvent e) {
        }
    }
}

