/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.ComplexArray;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.Logger;
import com.jniwrapper.util.StreamUtils;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Size;
import com.jniwrapper.win32.gdi.Bitmap;
import com.jniwrapper.win32.gdi.BitmapInfo;
import com.jniwrapper.win32.gdi.BitmapInfoHeader;
import com.jniwrapper.win32.gdi.BitmapStructure;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.DDBitmap;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.IconDir;
import com.jniwrapper.win32.gdi.IconDirEntry;
import com.jniwrapper.win32.gdi.IconInfo;
import com.jniwrapper.win32.gdi.RGBQuad;
import com.jniwrapper.win32.gdi.WindowDC;
import com.jniwrapper.win32.ui.User32;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Icon
extends GdiObject {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$gdi$Icon == null ? (class$com$jniwrapper$win32$gdi$Icon = Icon.class$("com.jniwrapper.win32.gdi.Icon")) : class$com$jniwrapper$win32$gdi$Icon));
    private static final FunctionName FUNCTION_LOAD_ICON = new FunctionName("LoadIcon");
    private static final FunctionName FUNCTION_LOAD_IMAGE = new FunctionName("LoadImage");
    private static final String FUNCTION_GET_ICON_INFO = "GetIconInfo";
    private static final String FUNCTION_CreateIconIndirect = "CreateIconIndirect";
    private Dimension _size = new Dimension(IconType.SMALL.getSize());
    private int _bitCount;
    private static final int typeICO = 1;
    private static final int typeCUR = 2;
    static /* synthetic */ Class class$com$jniwrapper$win32$gdi$Icon;
    static /* synthetic */ Class class$com$jniwrapper$Int8;
    static /* synthetic */ Class class$com$jniwrapper$UInt8;

    static Function getFunction(Object functionName) {
        return User32.getInstance().getFunction(functionName.toString());
    }

    protected void update() {
        IconInfo iconInfo;
        Bitmap colorBitmap;
        if (!this.isNull() && !(colorBitmap = (iconInfo = this.getIconInfo()).getColorBitmap()).isNull()) {
            Size size = colorBitmap.getSize();
            this._size.width = size.getCx();
            this._size.height = size.getCy();
            this._bitCount = colorBitmap.getBitCount();
        }
    }

    public Icon() {
    }

    public Icon(long value) {
        super(value);
    }

    public Icon(Dimension size) {
        this._size.setSize(size);
    }

    public Icon(String iconName) {
        this(new Handle(), iconName);
    }

    public Icon(Handle hInstance, String iconName) {
        Function function = Icon.getFunction(FUNCTION_LOAD_ICON);
        long errorCode = function.invoke((Parameter)this, (Parameter)hInstance, (Parameter)new Str(iconName));
        if (this.isNull()) {
            throw new LastErrorException(errorCode, "Failed to load icon.", true);
        }
        this.update();
    }

    public Icon(File file) {
        this.load(file);
    }

    public Icon(File file, Dimension size) {
        this.load(file, size);
    }

    public Icon(Handle hInstance, File file) {
        this.load(hInstance, file, this.getSize());
    }

    public void load(File file) {
        this.load(file, this.getSize());
    }

    public void load(File file, Dimension size) {
        this.load(new Handle(), file, size);
    }

    public void load(Handle hInstance, File file, Dimension size) {
        if (file == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exsist.");
        }
        if (size == null) {
            throw new IllegalArgumentException("Invalid size parameter.");
        }
        Function function = Icon.getFunction(FUNCTION_LOAD_IMAGE.toString());
        long errorCode = function.invoke((Parameter)this, new Parameter[]{hInstance, new Str(file.getAbsolutePath()), new UInt((long)GdiObject.ImageType.ICON.getValue()), new Int((long)size.width), new Int((long)size.height), new UInt(32784L)});
        if (this.isNull()) {
            throw new LastErrorException(errorCode, "Failed to load icon.", true);
        }
        this.update();
    }

    public Icon(InputStream stream) throws IOException {
        this.load(stream, this.getSize());
    }

    public Icon(InputStream stream, Dimension size) throws IOException {
        this.load(stream, size);
    }

    public Icon(Component c, javax.swing.Icon icon) {
        this();
        this.load(c, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Component c, javax.swing.Icon icon) {
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage colorImage = new BufferedImage(width, height, 2);
        BufferedImage maskImage = new BufferedImage(width, height, 1);
        icon.paintIcon(c, colorImage.getGraphics(), 0, 0);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (colorImage.getRGB(i, j) == 0) {
                    maskImage.setRGB(i, j, 0xFFFFFF);
                    continue;
                }
                maskImage.setRGB(i, j, 0);
            }
        }
        DDBitmap colorBitmap = new DDBitmap(colorImage);
        DDBitmap maskBitmap = new DDBitmap(maskImage);
        IconInfo iconInfo = new IconInfo(maskBitmap, colorBitmap);
        Function createIconIndirect = Icon.getFunction(FUNCTION_CreateIconIndirect);
        try {
            long errorCode = createIconIndirect.invoke((Parameter)this, (Parameter)new Pointer((Parameter)iconInfo));
            if (this.isNull()) {
                throw new LastErrorException(errorCode, "Failed to create icon from the resource.");
            }
        }
        finally {
            colorBitmap.deleteObject();
            maskBitmap.deleteObject();
        }
    }

    public void load(InputStream stream, Dimension size) throws IOException {
        this.loadFromStream(stream, size, -1);
    }

    public void load(InputStream stream, int iconIndex) throws IOException {
        this.loadFromStream(stream, null, iconIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromStream(InputStream stream, Dimension size, int iconIndex) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = StreamUtils.readBytes((InputStream)stream);
        if (bytes.length == 0) {
            throw new IllegalArgumentException("Input Stream is empty.");
        }
        IconDir iconDir = new IconDir();
        iconDir.read(bytes, 0);
        int type = iconDir.getType();
        if (type != 1) {
            throw new IllegalArgumentException("Invalid icon stream");
        }
        int count = iconDir.getCount();
        iconDir.getEntries().setElementCount(count);
        ComplexArray entries = iconDir.getEntries();
        boolean resourceFound = false;
        for (int i = 0; i < count; ++i) {
            List colors;
            IconDirEntry iconDirEntry = (IconDirEntry)entries.getElement(i);
            int offset = iconDir.getLength() + i * iconDirEntry.getLength();
            iconDirEntry.read(bytes, offset);
            int width = iconDirEntry.getWidth();
            int height = iconDirEntry.getHeight();
            if (size == null) {
                if (i != iconIndex) {
                    continue;
                }
            } else {
                boolean sizeEquals;
                boolean bl = sizeEquals = width == size.width && height == size.height;
                if (!sizeEquals) continue;
            }
            resourceFound = true;
            int imageDataOffset = iconDirEntry.getImageOffset();
            int imageDataSize = iconDirEntry.getBytesInRes();
            byte[] imageData = new byte[imageDataSize];
            System.arraycopy(bytes, imageDataOffset, imageData, 0, imageDataSize);
            offset = 0;
            BitmapInfo bitmapInfo = new BitmapInfo();
            bitmapInfo.read(imageData, offset);
            BitmapInfoHeader bitmapInfoHeader = bitmapInfo.getBitmapInfoHeader();
            offset += bitmapInfoHeader.getLength();
            int colorsUsed = (int)bitmapInfoHeader.getClrUsed();
            long bitCount = bitmapInfoHeader.getBitCount();
            if (colorsUsed == 0 && bitCount == 8L) {
                colorsUsed = 256;
            }
            if (colorsUsed == 0 && bitCount == 4L) {
                colorsUsed = 16;
            }
            List list = colors = colorsUsed > 0 ? new ArrayList(colorsUsed) : Collections.EMPTY_LIST;
            if (colorsUsed > 0) {
                for (int index = 0; index < colorsUsed; ++index) {
                    RGBQuad rgbQuad = new RGBQuad();
                    rgbQuad.read(imageData, offset);
                    colors.add(rgbQuad);
                    offset += rgbQuad.getLength();
                }
            }
            int bitmapHeight = (int)bitmapInfoHeader.getHeight();
            int scanLines = bitmapHeight / 2;
            int bitmapWidth = (int)bitmapInfoHeader.getWidth();
            int scanLineSizeInBytes = (int)((long)bitmapWidth * bitCount / 8L);
            int xorBytesCount = scanLineSizeInBytes * scanLines;
            byte[] xorBytes = new byte[xorBytesCount];
            System.arraycopy(imageData, offset, xorBytes, 0, xorBytesCount);
            offset += xorBytesCount;
            BitmapInfo xorBitmapInfo = new BitmapInfo(colorsUsed);
            BitmapInfoHeader xorBitmapInfoHeader = xorBitmapInfo.getBitmapInfoHeader();
            xorBitmapInfoHeader.setWidth(bitmapWidth);
            xorBitmapInfoHeader.setHeight(scanLines);
            xorBitmapInfoHeader.setPlanes(1L);
            xorBitmapInfoHeader.setBitCount(bitCount);
            xorBitmapInfoHeader.setCompression(Bitmap.Compression.RGB);
            xorBitmapInfoHeader.setSizeImage(0L);
            if (colorsUsed > 0) {
                xorBitmapInfoHeader.setClrUsed(colorsUsed);
                xorBitmapInfoHeader.setClrImportant(colorsUsed);
                PrimitiveArray xorColors = xorBitmapInfo.getColors();
                for (int index = 0; index < colorsUsed; ++index) {
                    xorColors.setElement(index, (Parameter)colors.get(index));
                }
            }
            WindowDC dc = new WindowDC(null);
            DC compatibleDC = DC.createCompatibleDC(dc);
            DDBitmap xorBitmap = new DDBitmap(dc, width, scanLines);
            PrimitiveArray xorBitmapData = new PrimitiveArray(xorBytes, class$com$jniwrapper$Int8 == null ? (class$com$jniwrapper$Int8 = Icon.class$("com.jniwrapper.Int8")) : class$com$jniwrapper$Int8);
            xorBitmap.setDIBits(compatibleDC, 0, scanLines, new Pointer((Parameter)xorBitmapData), xorBitmapInfo, 0);
            scanLineSizeInBytes = (bitmapWidth + 31) / 32 * 4;
            int andBytesCount = scanLines * scanLineSizeInBytes;
            byte[] andBytes = new byte[andBytesCount];
            System.arraycopy(imageData, offset, andBytes, 0, andBytesCount);
            BitmapInfo andBitmapInfo = new BitmapInfo(2);
            BitmapInfoHeader andBitmapInfoHeader = andBitmapInfo.getBitmapInfoHeader();
            andBitmapInfoHeader.setWidth(width);
            andBitmapInfoHeader.setHeight(scanLines);
            andBitmapInfoHeader.setPlanes(1L);
            andBitmapInfoHeader.setBitCount(1L);
            andBitmapInfoHeader.setCompression(Bitmap.Compression.RGB);
            andBitmapInfoHeader.setSizeImage(0L);
            andBitmapInfoHeader.setClrUsed(2L);
            andBitmapInfoHeader.setClrImportant(2L);
            PrimitiveArray andColors = andBitmapInfo.getColors();
            andColors.setElement(0, (Parameter)new RGBQuad(0, 0, 0));
            andColors.setElement(1, (Parameter)new RGBQuad(255, 255, 255));
            PrimitiveArray andBitmapData = new PrimitiveArray(andBytes, class$com$jniwrapper$UInt8 == null ? (class$com$jniwrapper$UInt8 = Icon.class$("com.jniwrapper.UInt8")) : class$com$jniwrapper$UInt8);
            DDBitmap andBitmap = new DDBitmap(dc, width, scanLines);
            andBitmap.setDIBits(compatibleDC, 0, scanLines, new Pointer((Parameter)andBitmapData), andBitmapInfo, 0);
            compatibleDC.release();
            ((DC)dc).release();
            IconInfo iconInfo = new IconInfo(andBitmap, xorBitmap);
            Function createIconIndirect = Icon.getFunction(FUNCTION_CreateIconIndirect);
            try {
                long errorCode = createIconIndirect.invoke((Parameter)this, (Parameter)new Pointer((Parameter)iconInfo));
                if (this.isNull()) {
                    throw new LastErrorException(errorCode, "Failed to create icon from the resource.");
                }
                break;
            }
            finally {
                xorBitmap.deleteObject();
                andBitmap.deleteObject();
            }
        }
        if (!resourceFound) {
            throw new IOException("Resource of specified size(" + size + "); or index (" + iconIndex + ") was not found in the specified stream.");
        }
        this.update();
    }

    public IconInfo getIconInfo() {
        IconInfo result = new IconInfo();
        Function function = Icon.getFunction(FUNCTION_GET_ICON_INFO);
        Bool returnValue = new Bool();
        long errorCode = function.invoke((Parameter)returnValue, (Parameter)this, (Parameter)new Pointer((Parameter)result));
        if (!returnValue.getValue()) {
            throw new LastErrorException(errorCode, "Failed to retrieve IconInfo for this icon.");
        }
        return result;
    }

    public Dimension getSize() {
        return this._size;
    }

    public int getBitCount() {
        return this._bitCount;
    }

    public BufferedImage toImage() {
        IconInfo iconInfo = this.getIconInfo();
        Bitmap mask = iconInfo.getMaskBitmap();
        Bitmap color = iconInfo.getColorBitmap();
        WindowDC dc = new WindowDC(null);
        BitmapStructure bitmapStructure = new BitmapStructure();
        this.getObject(color, (Parameter)bitmapStructure);
        int bitCount = (int)bitmapStructure.getBitsPixel();
        BitmapInfo bitmapInfo = bitCount >= 16 ? new BitmapInfo() : new BitmapInfo(bitCount);
        BitmapInfoHeader bitmapInfoHeader = bitmapInfo.getBitmapInfoHeader();
        int width = (int)bitmapStructure.getBitmapWidth();
        int height = (int)bitmapStructure.getBitmapHeight();
        bitmapInfoHeader.setWidth(width);
        bitmapInfoHeader.setHeight(height);
        bitmapInfoHeader.setPlanes(1L);
        bitmapInfoHeader.setBitCount(bitCount);
        bitmapInfoHeader.setCompression(Bitmap.Compression.RGB);
        if (bitCount == 4 || bitCount == 8) {
            int clrUsed = 1 << bitCount;
            bitmapInfoHeader.setClrUsed(clrUsed);
            bitmapInfoHeader.setClrImportant(clrUsed);
        }
        Pointer NULL = new Pointer(null, true);
        color.getDIBits((DC)dc, 0, height, NULL, bitmapInfo, 0);
        int bytesCount = (int)bitmapInfoHeader.getSizeImage();
        PrimitiveArray colorBits = new PrimitiveArray(class$com$jniwrapper$UInt8 == null ? (class$com$jniwrapper$UInt8 = Icon.class$("com.jniwrapper.UInt8")) : class$com$jniwrapper$UInt8, bytesCount);
        color.getDIBits((DC)dc, 0, height, new Pointer((Parameter)colorBits), bitmapInfo, 0);
        PrimitiveArray maskBits = new PrimitiveArray(class$com$jniwrapper$UInt8 == null ? (class$com$jniwrapper$UInt8 = Icon.class$("com.jniwrapper.UInt8")) : class$com$jniwrapper$UInt8, bytesCount);
        mask.getDIBits((DC)dc, 0, height, new Pointer((Parameter)maskBits), bitmapInfo, 0);
        dc.release();
        PrimitiveArray colors = bitmapInfo.getColors();
        BufferedImage result = new BufferedImage(width, height, 2);
        int index1 = 0;
        int index2 = 0;
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                int rgb1 = 0;
                int rgb2 = 0;
                switch (bitCount) {
                    case 8: {
                        RGBQuad pixelColor1 = (RGBQuad)colors.getElement(index1++);
                        int r1 = (int)pixelColor1.getRed();
                        int g1 = (int)pixelColor1.getGreen();
                        int b1 = (int)pixelColor1.getBlue();
                        rgb1 = 0xFF000000 | b1 | g1 | r1;
                        RGBQuad pixelColor2 = (RGBQuad)colors.getElement(index2++);
                        int r2 = (int)pixelColor2.getRed();
                        int g2 = (int)pixelColor2.getGreen();
                        int b2 = (int)pixelColor2.getBlue();
                        rgb2 = b2 | g2 | r2;
                        break;
                    }
                    case 16: {
                        int byte1 = Icon.readByte(colorBits, index1++);
                        int byte2 = Icon.readByte(colorBits, index1++);
                        int word = byte2 << 8 | byte1;
                        int b1 = (word & 0x1F) << 3;
                        int g1 = (word & 0x3E0) << 6;
                        int r1 = (word & 0x7C00) << 9;
                        rgb1 = 0xFF000000 | b1 | g1 | r1;
                        byte1 = Icon.readByte(maskBits, index2++);
                        byte2 = Icon.readByte(maskBits, index2++);
                        word = byte2 << 8 | byte1;
                        int b2 = (word & 0x1F) << 3;
                        int g2 = (word & 0x3E0) << 6;
                        int r2 = (word & 0x7C00) << 9;
                        rgb2 = b2 | g2 | r2;
                        break;
                    }
                    case 24: 
                    case 32: {
                        int b1 = Icon.readByte(colorBits, index1++);
                        int g1 = Icon.readByte(colorBits, index1++);
                        int r1 = Icon.readByte(colorBits, index1++);
                        rgb1 = b1 | g1 << 8 | r1 << 16;
                        if (bitCount == 32) {
                            int alpha;
                            if ((alpha = Icon.readByte(colorBits, index1++)) == 0) {
                                alpha = 255;
                            }
                            rgb1 |= alpha << 24;
                        } else {
                            rgb1 |= 0xFF000000;
                        }
                        int b2 = Icon.readByte(maskBits, index2++);
                        int g2 = Icon.readByte(maskBits, index2++);
                        int r2 = Icon.readByte(maskBits, index2++);
                        rgb2 = b2 | g2 << 8 | r2 << 16;
                        if (bitCount != 32) break;
                        ++index2;
                    }
                }
                if (rgb2 != 0) {
                    result.setRGB(x, y, rgb2);
                    continue;
                }
                result.setRGB(x, y, rgb1);
            }
        }
        return result;
    }

    private static int readByte(PrimitiveArray bits, int offset) {
        UInt8 element = (UInt8)bits.getElement(offset);
        return (int)element.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List loadFromStream(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException();
        }
        LinkedList<Icon> result = new LinkedList<Icon>();
        Function createIconIndirect = User32.getInstance().getFunction(FUNCTION_CreateIconIndirect);
        byte[] bytes = StreamUtils.readBytes((InputStream)stream);
        if (bytes.length == 0) {
            throw new IllegalArgumentException("Input Stream is empty.");
        }
        IconDir iconDir = new IconDir();
        iconDir.read(bytes, 0);
        int type = iconDir.getType();
        if (type != 1) {
            throw new IllegalArgumentException("Invalid icon stream");
        }
        int count = iconDir.getCount();
        iconDir.getEntries().setElementCount(count);
        ComplexArray entries = iconDir.getEntries();
        for (int i = 0; i < count; ++i) {
            List colors;
            IconDirEntry iconDirEntry = (IconDirEntry)entries.getElement(i);
            int offset = iconDir.getLength() + i * iconDirEntry.getLength();
            iconDirEntry.read(bytes, offset);
            int width = iconDirEntry.getWidth();
            int height = iconDirEntry.getHeight();
            if (width == 0 && height == 0) continue;
            int imageDataOffset = iconDirEntry.getImageOffset();
            int imageDataSize = iconDirEntry.getBytesInRes();
            byte[] imageData = new byte[imageDataSize];
            System.arraycopy(bytes, imageDataOffset, imageData, 0, imageDataSize);
            offset = 0;
            BitmapInfo bitmapInfo = new BitmapInfo();
            bitmapInfo.read(imageData, offset);
            BitmapInfoHeader bitmapInfoHeader = bitmapInfo.getBitmapInfoHeader();
            offset += bitmapInfoHeader.getLength();
            int colorsUsed = (int)bitmapInfoHeader.getClrUsed();
            long bitCount = bitmapInfoHeader.getBitCount();
            if (colorsUsed == 0 && bitCount == 8L) {
                colorsUsed = 256;
            }
            if (colorsUsed == 0 && bitCount == 4L) {
                colorsUsed = 16;
            }
            List list = colors = colorsUsed > 0 ? new ArrayList(colorsUsed) : Collections.EMPTY_LIST;
            if (colorsUsed > 0) {
                for (int index = 0; index < colorsUsed; ++index) {
                    RGBQuad rgbQuad = new RGBQuad();
                    rgbQuad.read(imageData, offset);
                    colors.add(rgbQuad);
                    offset += rgbQuad.getLength();
                }
            }
            int bitmapHeight = (int)bitmapInfoHeader.getHeight();
            int scanLines = bitmapHeight / 2;
            int bitmapWidth = (int)bitmapInfoHeader.getWidth();
            int scanLineSizeInBytes = (int)((long)bitmapWidth * bitCount / 8L);
            int xorBytesCount = scanLineSizeInBytes * scanLines;
            byte[] xorBytes = new byte[xorBytesCount];
            System.arraycopy(imageData, offset, xorBytes, 0, xorBytesCount);
            offset += xorBytesCount;
            BitmapInfo xorBitmapInfo = new BitmapInfo(colorsUsed);
            BitmapInfoHeader xorBitmapInfoHeader = xorBitmapInfo.getBitmapInfoHeader();
            xorBitmapInfoHeader.setWidth(bitmapWidth);
            xorBitmapInfoHeader.setHeight(scanLines);
            xorBitmapInfoHeader.setPlanes(1L);
            xorBitmapInfoHeader.setBitCount(bitCount);
            xorBitmapInfoHeader.setCompression(Bitmap.Compression.RGB);
            xorBitmapInfoHeader.setSizeImage(0L);
            if (colorsUsed > 0) {
                xorBitmapInfoHeader.setClrUsed(colorsUsed);
                xorBitmapInfoHeader.setClrImportant(colorsUsed);
                PrimitiveArray xorColors = xorBitmapInfo.getColors();
                for (int index = 0; index < colorsUsed; ++index) {
                    xorColors.setElement(index, (Parameter)colors.get(index));
                }
            }
            WindowDC dc = new WindowDC(null);
            DC compatibleDC = DC.createCompatibleDC(dc);
            DDBitmap xorBitmap = new DDBitmap(dc, width, scanLines);
            PrimitiveArray xorBitmapData = new PrimitiveArray(xorBytes, class$com$jniwrapper$Int8 == null ? Icon.class$("com.jniwrapper.Int8") : class$com$jniwrapper$Int8);
            xorBitmap.setDIBits(compatibleDC, 0, scanLines, new Pointer((Parameter)xorBitmapData), xorBitmapInfo, 0);
            scanLineSizeInBytes = (bitmapWidth + 31) / 32 * 4;
            int andBytesCount = scanLines * scanLineSizeInBytes;
            byte[] andBytes = new byte[andBytesCount];
            System.arraycopy(imageData, offset, andBytes, 0, andBytesCount);
            BitmapInfo andBitmapInfo = new BitmapInfo(2);
            BitmapInfoHeader andBitmapInfoHeader = andBitmapInfo.getBitmapInfoHeader();
            andBitmapInfoHeader.setWidth(width);
            andBitmapInfoHeader.setHeight(scanLines);
            andBitmapInfoHeader.setPlanes(1L);
            andBitmapInfoHeader.setBitCount(1L);
            andBitmapInfoHeader.setCompression(Bitmap.Compression.RGB);
            andBitmapInfoHeader.setSizeImage(0L);
            andBitmapInfoHeader.setClrUsed(2L);
            andBitmapInfoHeader.setClrImportant(2L);
            PrimitiveArray andColors = andBitmapInfo.getColors();
            andColors.setElement(0, (Parameter)new RGBQuad(0, 0, 0));
            andColors.setElement(1, (Parameter)new RGBQuad(255, 255, 255));
            PrimitiveArray andBitmapData = new PrimitiveArray(andBytes, class$com$jniwrapper$UInt8 == null ? Icon.class$("com.jniwrapper.UInt8") : class$com$jniwrapper$UInt8);
            DDBitmap andBitmap = new DDBitmap(dc, width, scanLines);
            andBitmap.setDIBits(compatibleDC, 0, scanLines, new Pointer((Parameter)andBitmapData), andBitmapInfo, 0);
            compatibleDC.release();
            ((DC)dc).release();
            IconInfo iconInfo = new IconInfo(andBitmap, xorBitmap);
            try {
                Icon icon = new Icon();
                long errorCode = createIconIndirect.invoke((Parameter)icon, (Parameter)new Pointer((Parameter)iconInfo));
                if (icon.isNull()) {
                    throw new LastErrorException(errorCode, "Failed to create icon from the resource.");
                }
                icon._size.setSize(width, height);
                icon._bitCount = (int)bitCount;
                result.add(icon);
                continue;
            }
            finally {
                xorBitmap.deleteObject();
                andBitmap.deleteObject();
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class IconType
    extends EnumItem {
        public static final IconType SMALL = new IconType(0, new Dimension(16, 16));
        public static final IconType BIG = new IconType(1, new Dimension(32, 32));
        private Dimension _size;

        private IconType(int value, Dimension size) {
            super(value);
            this._size = size;
        }

        public Dimension getSize() {
            return this._size;
        }
    }

    public static class SystemIcon
    extends EnumItem {
        public static final SystemIcon SAMPLE = new SystemIcon(32512);
        public static final SystemIcon HAND = new SystemIcon(32513);
        public static final SystemIcon QUES = new SystemIcon(32514);
        public static final SystemIcon BANG = new SystemIcon(32515);
        public static final SystemIcon NOTE = new SystemIcon(32516);
        public static final SystemIcon WINLOGO = new SystemIcon(32517);
        private Icon _smallIcon;
        private Icon _bigIcon;

        private SystemIcon(int value) {
            super(value);
        }

        public static Icon loadSystemIcon(int iconID, Dimension size) {
            Icon result = new Icon();
            Function function = Icon.getFunction(FUNCTION_LOAD_IMAGE);
            long errorCode = function.invoke((Parameter)result, new Parameter[]{new Handle(), new Int32(iconID), new UInt32((long)GdiObject.ImageType.ICON.getValue()), new Int((long)size.width), new Int((long)size.height), new UInt32(32768L)});
            if (result.isNull()) {
                throw new LastErrorException(errorCode, "Failed to load icon for " + iconID);
            }
            return result;
        }

        public Icon getIcon(IconType type) {
            Icon result = null;
            if (type.equals((Object)IconType.SMALL)) {
                if (this._smallIcon == null) {
                    this._smallIcon = SystemIcon.loadSystemIcon(this.getValue(), type.getSize());
                }
                result = this._smallIcon;
            } else if (type.equals((Object)IconType.BIG)) {
                if (this._bigIcon == null) {
                    this._bigIcon = SystemIcon.loadSystemIcon(this.getValue(), type.getSize());
                }
                result = this._bigIcon;
            }
            return result;
        }

        public Icon getSmall() {
            return this.getIcon(IconType.SMALL);
        }

        public Icon getBig() {
            return this.getIcon(IconType.BIG);
        }
    }
}

