/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.hook.data;

import com.jniwrapper.Bool;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Structure;
import com.jniwrapper.win32.hook.EventsFilter;
import com.jniwrapper.win32.ui.Wnd;
import java.util.List;

class EventsFilterStucture
extends Structure {
    private Int windowsCount = new Int();
    private PrimitiveArray windows = new PrimitiveArray(class$com$jniwrapper$win32$hook$data$EventsFilterStucture$WindowStructure == null ? (class$com$jniwrapper$win32$hook$data$EventsFilterStucture$WindowStructure = EventsFilterStucture.class$("com.jniwrapper.win32.hook.data.EventsFilterStucture$WindowStructure")) : class$com$jniwrapper$win32$hook$data$EventsFilterStucture$WindowStructure, 10);
    private Int rangesCount = new Int();
    private PrimitiveArray ranges = new PrimitiveArray(class$com$jniwrapper$win32$hook$data$EventsFilterStucture$RangeStructure == null ? (class$com$jniwrapper$win32$hook$data$EventsFilterStucture$RangeStructure = EventsFilterStucture.class$("com.jniwrapper.win32.hook.data.EventsFilterStucture$RangeStructure")) : class$com$jniwrapper$win32$hook$data$EventsFilterStucture$RangeStructure, 30);
    static /* synthetic */ Class class$com$jniwrapper$win32$hook$data$EventsFilterStucture$WindowStructure;
    static /* synthetic */ Class class$com$jniwrapper$win32$hook$data$EventsFilterStucture$RangeStructure;

    EventsFilterStucture() {
        this.init(new Parameter[]{this.windowsCount, this.windows, this.rangesCount, this.ranges}, (short)1);
    }

    public void applyEventsFilter(EventsFilter filter) {
        if (filter == null) {
            throw new NullPointerException("Invalid events filter");
        }
        List windows = filter.getWindows();
        this.windowsCount.setValue((long)Math.min(windows.size(), 10));
        for (int i = 0; i < 10; ++i) {
            if (i < windows.size()) {
                EventsFilter.WindowRecord windowRecord = (EventsFilter.WindowRecord)windows.get(i);
                WindowStructure windowStructure = new WindowStructure(windowRecord);
                this.windows.setElement(i, (Parameter)windowStructure);
                continue;
            }
            this.windows.setElement(i, (Parameter)new Wnd());
        }
        List ranges = filter.getRanges();
        this.rangesCount.setValue((long)Math.min(ranges.size(), 30));
        for (int i = 0; i < 30; ++i) {
            if (i < ranges.size()) {
                EventsFilter.Range range = (EventsFilter.Range)ranges.get(i);
                RangeStructure rangeStructure = new RangeStructure(range);
                this.ranges.setElement(i, (Parameter)rangeStructure);
                continue;
            }
            this.ranges.setElement(i, (Parameter)new RangeStructure());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class RangeStructure
    extends Structure {
        private Int lowerBound = new Int();
        private Int upperBound = new Int();

        public RangeStructure() {
            this.init(new Parameter[]{this.lowerBound, this.upperBound}, (short)1);
        }

        public RangeStructure(int lowerBound, int upperBound) {
            this();
            this.lowerBound.setValue((long)lowerBound);
            this.upperBound.setValue((long)upperBound);
        }

        public RangeStructure(EventsFilter.Range range) {
            this(range.getLowerBound(), range.getUpperBound());
        }

        public Object clone() {
            RangeStructure clone = new RangeStructure();
            clone.initFrom(this);
            return clone;
        }
    }

    protected static class WindowStructure
    extends Structure {
        private Wnd wnd = new Wnd();
        private Bool includeChildWindows = new Bool();

        public WindowStructure() {
            this.init(new Parameter[]{this.wnd, this.includeChildWindows}, (short)1);
        }

        public WindowStructure(EventsFilter.WindowRecord windowRecord) {
            this();
            this.wnd.setValue(windowRecord.getWnd().getValue());
            this.includeChildWindows.setValue(windowRecord.isIncludeChildWindows());
        }

        public Wnd getWnd() {
            return this.wnd;
        }

        public Bool getIncludeChildWindows() {
            return this.includeChildWindows;
        }

        public Object clone() {
            WindowStructure clone = new WindowStructure();
            clone.initFrom(this);
            return clone;
        }
    }
}

