/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.ui.User32;
import com.jniwrapper.win32.ui.Wnd;

public class GUIThreadInfo
extends Structure {
    public static final int GUI_CARETBLINKING = 1;
    public static final int GUI_INMOVESIZE = 2;
    public static final int GUI_INMENUMODE = 4;
    public static final int GUI_SYSTEMMENUMODE = 8;
    public static final int GUI_POPUPMENUMODE = 16;
    public static final int GUI_16BITTASK = 32;
    private UInt32 cbSize = new UInt32();
    private UInt32 flags = new UInt32();
    private Wnd hwndActive = new Wnd();
    private Wnd hwndFocus = new Wnd();
    private Wnd hwndCapture = new Wnd();
    private Wnd hwndMenuOwner = new Wnd();
    private Wnd hwndMoveSize = new Wnd();
    private Wnd hwndCaret = new Wnd();
    private Rect rcCaret = new Rect();

    public GUIThreadInfo() {
        this.init(new Parameter[]{this.cbSize, this.flags, this.hwndActive, this.hwndFocus, this.hwndCapture, this.hwndMenuOwner, this.hwndMoveSize, this.hwndCaret, this.rcCaret});
        this.cbSize.setValue((long)this.getLength());
    }

    public UInt32 getCbSize() {
        return this.cbSize;
    }

    public UInt32 getFlags() {
        return this.flags;
    }

    public Wnd getHwndActive() {
        return this.hwndActive;
    }

    public Wnd getHwndFocus() {
        return this.hwndFocus;
    }

    public Wnd getHwndCapture() {
        return this.hwndCapture;
    }

    public Wnd getHwndMenuOwner() {
        return this.hwndMenuOwner;
    }

    public Wnd getHwndMoveSize() {
        return this.hwndMoveSize;
    }

    public Wnd getHwndCaret() {
        return this.hwndCaret;
    }

    public Rect getRcCaret() {
        return this.rcCaret;
    }

    public static GUIThreadInfo getGUIThreadInfo(long threadID) {
        Function getGUIThreadInfo = User32.getInstance().getFunction("GetGUIThreadInfo");
        Bool result = new Bool();
        GUIThreadInfo resultValue = new GUIThreadInfo();
        long errorCode = getGUIThreadInfo.invoke((Parameter)result, (Parameter)new UInt32(threadID), (Parameter)new Pointer((Parameter)resultValue));
        if (!result.getValue()) {
            throw new LastErrorException(errorCode);
        }
        return resultValue;
    }
}

