/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui.controls;

import com.jniwrapper.win32.ui.controls.AbstractChooserField;
import com.jniwrapper.win32.ui.dialogs.ChooseColorDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public class ChooseColorField
extends AbstractChooserField {
    public static final String PROPERTY_COLOR = "color";
    private ChooseColorDialog _dialog;

    protected JComponent createField() {
        Dimension size = new Dimension(60, 20);
        JPanel result = new JPanel();
        result.setPreferredSize(size);
        result.setMinimumSize(size);
        result.setMaximumSize(size);
        result.setBackground(Color.black);
        result.setBorder(new EtchedBorder(1, Color.white, Color.gray));
        result.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ChooseColorField.this.actionPerformed(null);
                }
            }
        });
        return result;
    }

    public ChooseColorField() {
    }

    public ChooseColorField(Color color) {
        this();
        this.setColor(color);
    }

    public void actionPerformed(ActionEvent e) {
        ChooseColorDialog dialog = this.getDialog();
        Color oldColor = this.getColor();
        dialog.setColor(oldColor);
        if (dialog.execute()) {
            Color newColor = dialog.getColor();
            this.setColor(newColor);
            this.firePropertyChange(PROPERTY_COLOR, oldColor, newColor);
        }
    }

    public ChooseColorDialog getDialog() {
        if (this._dialog == null) {
            Window parent = SwingUtilities.getWindowAncestor(this);
            this._dialog = new ChooseColorDialog(parent);
        }
        return this._dialog;
    }

    public Color getColor() {
        return this.getField().getBackground();
    }

    public void setColor(Color color) {
        this.getField().setBackground(color);
    }
}

