/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.winhttp;

import com.jniwrapper.Function;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.win32.winhttp.AutoProxyOptions;
import com.jniwrapper.win32.winhttp.DefaultProxySettings;
import com.jniwrapper.win32.winhttp.ProxyInfo;
import com.jniwrapper.win32.winhttp.ProxySettings;
import com.jniwrapper.win32.winhttp.WinHttpException;
import com.jniwrapper.win32.winhttp.WinHttpLibrary;
import com.jniwrapper.win32.winhttp.WinHttpSession;

public class RemoteProxySettings
implements ProxySettings {
    private static final String FUNCTION_GET_PROXY_FOR_URL = "WinHttpGetProxyForUrl";
    private static final long WINHTTP_AUTOPROXY_AUTO_DETECT = 1L;
    private static final long WINHTTP_AUTOPROXY_CONFIG_URL = 2L;
    private static final long WINHTTP_AUTO_DETECT_TYPE_DHCP = 1L;
    private static final long WINHTTP_AUTO_DETECT_TYPE_DNS_A = 2L;
    private static final int WINHTTP_ACCESS_TYPE_NO_PROXY = 1;
    private boolean _isProxySet;
    private int _proxyPort;
    private String _proxyURL;
    private String _proxyBypass;

    public RemoteProxySettings(String url, boolean autoLogon) throws WinHttpException {
        if (url == null) {
            throw new IllegalArgumentException("URL argument is null.");
        }
        AutoProxyOptions options = new AutoProxyOptions();
        options.setFlags(1L);
        options.setAutoDetectFlags(3L);
        options.setAutoLogon(autoLogon);
        options.setAutoConfigUrl(null);
        this.readInfo(url, options);
    }

    public RemoteProxySettings(String url, String pacFileUrl, boolean autoLogon) throws WinHttpException {
        if (url == null) {
            throw new IllegalArgumentException("URL argument is null.");
        }
        if (pacFileUrl == null) {
            throw new IllegalArgumentException("pacFileUrl argument is null.");
        }
        AutoProxyOptions options = new AutoProxyOptions();
        options.setFlags(2L);
        options.setAutoDetectFlags(0L);
        options.setAutoLogon(autoLogon);
        options.setAutoConfigUrl(pacFileUrl);
        this.readInfo(url, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInfo(String url, AutoProxyOptions options) throws WinHttpException {
        WinHttpSession session = new WinHttpSession(null, null, null);
        try {
            Function function = WinHttpLibrary.getInstance().getFunction(FUNCTION_GET_PROXY_FOR_URL);
            IntBool result = new IntBool();
            ProxyInfo proxyInfo = new ProxyInfo();
            long lastError = function.invoke((Parameter)result, (Parameter)session, (Parameter)new Pointer((Parameter)new Str(url)), (Parameter)new Pointer((Parameter)options), (Parameter)new Pointer.OutOnly((Parameter)proxyInfo));
            if (result.getValue() == 0L) {
                throw new WinHttpException(lastError);
            }
            long accessType = proxyInfo.getAccessType();
            this._isProxySet = accessType != 1L;
            this._proxyBypass = proxyInfo.getProxyBypass();
            String proxy = proxyInfo.getProxy();
            int portOffset = proxy.lastIndexOf(58);
            String port = proxy.substring(portOffset + 1, proxy.length());
            try {
                this._proxyPort = new Integer(port);
                this._proxyURL = proxy.substring(0, portOffset);
            }
            catch (NumberFormatException e) {
                this._proxyPort = -1;
                this._proxyURL = proxy;
            }
        }
        finally {
            session.close();
        }
    }

    public boolean isSet() {
        return this._isProxySet;
    }

    public String getURL() {
        return this._proxyURL;
    }

    public int getPort() {
        return this._proxyPort;
    }

    public String[] getProxyBypass() {
        return DefaultProxySettings.parseBypasses(this._proxyBypass);
    }
}

