/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */

import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.hook.CBTEvent;
import com.jniwrapper.win32.hook.CBTHookAdapter;
import com.jniwrapper.win32.hook.Hook;
import com.jniwrapper.win32.ui.Wnd;

/**
 * This sample demonstrates how to install {@link com.jniwrapper.win32.hook.Hook#CBT} hook and listen to its events.
 *
 * @author Serge Piletsky
 */
public class CBTHookSample
{
    public static void main(String[] args) throws Exception
    {
        Hook.CBT.addListener(new CBTHookAdapter()
        {
            public void activate(CBTEvent.Activate event)
            {
                System.out.println("CBTEvent.Activate");

                Wnd activatedWindow = event.getActivatedWindow();
                System.out.println("activatedWindow = " + activatedWindow.getWindowText());

                Wnd activeWindow = event.getActiveWindow();
                System.out.println("activeWindow = " + activeWindow);

                boolean byMouse = event.isActivatedByMouse();
                System.out.println("byMouse = " + byMouse);
            }

            public void moveSize(CBTEvent.MoveSize event)
            {
                System.out.println("CBTEvent.MoveSize");

                Wnd wnd = event.getWindowHandle();
                System.out.println("wnd = " + wnd.getWindowText());
                Rect windowRect = event.getWindowRect();
                System.out.println("windowRect = " + windowRect);
                event.setAllow(false); // disallow move/size events
            }

            public void minMax(CBTEvent.MinMax event)
            {
                System.out.println("CBTEvent.MinMax");

                Wnd window = event.getWindowHandle();
                System.out.println("window = " + window.getWindowText());

                Wnd.ShowWindowCommand windowCommand = event.getOperation();
                System.out.println("windowCommand = " + windowCommand);

                event.setAllow(false); // disallow min/max events
            }

            public void clickSkipped(CBTEvent.ClickSkipped event)
            {
                System.out.println("CBTEvent.ClickSkipped");

                long mouseMessage = event.getMouseMessage();
                System.out.println("mouseMessage = " + mouseMessage);
                Wnd wnd = event.getWindow();
                System.out.println("wnd = " + wnd.getWindowText());
                Point point = event.getCursorCoordinates();
                System.out.println("point = " + point);
            }

            public void setFocus(CBTEvent.SetFocus event)
            {
                System.out.println("CBTEvent.SetFocus");

                Wnd windowGainingFocus = event.getWindowGainingFocus();
                System.out.println("windowGainingFocus = " + windowGainingFocus.getWindowText());
                Wnd windowLosingFocus = event.getWindowLosingFocus();
                System.out.println("windowLosingFocus = " + windowLosingFocus.getWindowText());
            }

            public void createWnd(CBTEvent.CreateWnd event)
            {
                System.out.println("CBTEvent.CreateWnd");

                Wnd newWindow = event.getNewWindow();
                System.out.println("newWindow = " + newWindow);
            }

            public void destroyWnd(CBTEvent.DestroyWnd event)
            {
                System.out.println("CBTEvent.DestroyWnd");

                Wnd window = event.getDestoyedWindow();
                System.out.println("window = " + window);
            }

            public void keySkipped(CBTEvent.KeySkipped event)
            {
                System.out.println("CBTEvent.KeySkipped");

                int code = event.getScanCode();
                System.out.println("code = " + code);
            }


            public void sysCommand(CBTEvent.SysCommand event)
            {
                System.out.println("CBTEvent.SysCommand");

                long sysCommand = event.getSysCommand();
                System.out.println("sysCommand = " + sysCommand);

                long info = event.getInfo();
                System.out.println("info = " + info);

            }
        });

        Hook.CBT.install();
        System.out.println("CBT Hook is successfully installed.");

        System.out.println("Press 'Enter' to terminate the sample.");
        System.in.read();

        Hook.CBT.uninstall();
        System.out.println("CBT Hook is successfully uninstalled.");
    }
}