import com.jniwrapper.win32.Msg;
import com.jniwrapper.win32.hook.*;
import com.jniwrapper.win32.ui.Wnd;

public class CallWindowProcSample
{
    public static void main(String[] args) throws Exception
    {
        Hook.CALLWNDPROC.addListener(new HookEventListener()
        {
            public void onHookEvent(HookEventObject event)
            {
                CallWndProcEvent callWndProcEvent = (CallWndProcEvent) event;
                System.out.println("Source = " + callWndProcEvent.getSource());
                System.out.println("\tLParam = " + callWndProcEvent.getLParam());
                System.out.println("\tWParam = " + callWndProcEvent.getWParam());
                System.out.println("\tWnd = " + callWndProcEvent.getWnd().getWindowClassName());
                System.out.println("\tmessage = " + callWndProcEvent.getMessage());
            }
        });

        EventsFilter filter = new EventsFilter();
        filter.setAllowAllWindows(true);

        filter.addEvent(32);
        filter.addEvents(new int[]{Msg.WM_DESTROY, Msg.WM_COMMAND});
        filter.addEventsRange(Msg.WM_MOVE, Msg.WM_SIZE);

        Hook.CALLWNDPROC.install();
        Hook.CALLWNDPROC.setFilter(filter); // must be installed after the installation of the hook

        System.out.println("Press 'Enter' to update hook filter");
        System.in.read();

//        filter.removeAllEvents();
//        filter.addEvents(new int[]{Msg.WM_MOVE, Msg.WM_SIZE});
        filter.setAllowAllEvents(true);
        filter.addWindow(new Wnd(0x0002027E), true);

        Hook.CALLWNDPROC.setFilter(filter); // must be installed after the installation of the hook

        System.out.println("Press 'Enter' to terminate application");
        System.in.read();

        Hook.CALLWNDPROC.uninstall();
        System.out.println("Done.");
    }
}
