/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
import java.util.List;
import java.util.Iterator;
import com.jniwrapper.win32.process.Process;
import com.jniwrapper.win32.process.ProcessSecurityOptions;
import com.jniwrapper.win32.LastErrorException;

/**
 * This sample demonstraits enumerating system processes, their executable file name and handles count.
 */
public class EnumProcessesSample
{

    /**
     * Sample entry point
     * @param args command-line arguments, ignored now
     */
    public static void main(String[] args) {
        // Get IDs of all processes in system
        List processes = Process.getProcesses();
        for (Iterator it = processes.iterator(); it.hasNext();)
        {
            Process process = (Process)it.next();
            if (!process.isNull())
            {
                long pid = process.getProcessID();
                try
                {
                    String fileName = process.getProcessImageFileName();
                    long handleCount = process.getHandleCount();

                    System.out.println("pid=" + pid + " executable=" + fileName + " handles=" + handleCount);
                }
                catch (LastErrorException e)
                {
                    System.out.println(
                        "Exception occured while trying to open PID " + pid +
                        " : " + e.getErrorMessage());
                }
                finally
                {
                    process.close();
                }
            }
        }
    }
}