/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */

import com.jniwrapper.win32.security.AccessToken;
import com.jniwrapper.win32.security.TokenGroups;
import com.jniwrapper.win32.security.SidAndAttributes;
import com.jniwrapper.win32.security.Sid;

/**
 * This sample checks admin rights of the current process.
 *
 * @author Vadim Ridosh
 */
public class EnumTokenGroups
{
    public static void main(String[] args)
    {
        EnumTokenGroups sample = new EnumTokenGroups();
        System.out.println("Available groups and their rights:");
        sample.traceAvailableGroups();
    }

    private void traceAvailableGroups()
    {
        // Empty AccessToken constructor creates access token for current user
        AccessToken token = new AccessToken();

        // Obtain groups from the token
        TokenGroups tokenGroups = token.getTokenGroups();
        if (tokenGroups != null)
        {
            // Enumerate groups
            int count = tokenGroups.getGroupCount();
            for (int group = 0; group < count; ++group)
            {
                SidAndAttributes sidAndAttributes = tokenGroups.getGroups(group);

                // Obtain group attribute
                long value = sidAndAttributes.getAttributes().getValue();
                Sid sid = sidAndAttributes.getSid();

                if (sid.equals(Sid.Null()))
                {
                    System.out.print("Null");
                }
                else if (sid.equals(Sid.World()))
                {
                    System.out.print("World");
                }
                else if (sid.equals(Sid.Local()))
                {
                    System.out.print("Local");
                }
                else if (sid.equals(Sid.CreatorOwner()))
                {
                    System.out.print("CreatorOwner");
                }
                else if (sid.equals(Sid.CreatorGroup()))
                {
                    System.out.print("CreatorGroup");
                }
                else if (sid.equals(Sid.CreatorOwnerServer()))
                {
                    System.out.print("CreatorOwnerServer");
                }
                else if (sid.equals(Sid.CreatorGroupServer()))
                {
                    System.out.print("CreatorGroupServer");
                }
                else if (sid.equals(Sid.Dialup()))
                {
                    System.out.print("Dialup");
                }
                else if (sid.equals(Sid.Network()))
                {
                    System.out.print("Network");
                }
                else if (sid.equals(Sid.Batch()))
                {
                    System.out.print("Batch");
                }
                else if (sid.equals(Sid.Interactive()))
                {
                    System.out.print("Interactive");
                }
                else if (sid.equals(Sid.Service()))
                {
                    System.out.print("Service");
                }
                else if (sid.equals(Sid.AnonymousLogon()))
                {
                    System.out.print("AnonymousLogon");
                }
                else if (sid.equals(Sid.Proxy()))
                {
                    System.out.print("Proxy");
                }
                else if (sid.equals(Sid.ServerLogon()))
                {
                    System.out.print("ServerLogon");
                }
                else if (sid.equals(Sid.Self()))
                {
                    System.out.print("Self");
                }
                else if (sid.equals(Sid.AuthenticatedUser()))
                {
                    System.out.print("AuthenticatedUser");
                }
                else if (sid.equals(Sid.RestrictedCode()))
                {
                    System.out.print("RestrictedCode");
                }
                else if (sid.equals(Sid.TerminalServer()))
                {
                    System.out.print("TerminalServer");
                }
                else if (sid.equals(Sid.System()))
                {
                    System.out.print("System");
                }
                else if (sid.equals(Sid.NetworkService()))
                {
                    System.out.print("NetworkService");
                }
                else if (sid.equals(Sid.Admins()))
                {
                    System.out.print("Admins");
                }
                else if (sid.equals(Sid.Users()))
                {
                    System.out.print("Users");
                }
                else if (sid.equals(Sid.Guests()))
                {
                    System.out.print("Guests");
                }
                else if (sid.equals(Sid.PowerUsers()))
                {
                    System.out.print("PowerUsers");
                }
                else if (sid.equals(Sid.AccountOps()))
                {
                    System.out.print("AccountOps");
                }
                else if (sid.equals(Sid.SystemOps()))
                {
                    System.out.print("SystemOps");
                }
                else if (sid.equals(Sid.PrintOps()))
                {
                    System.out.print("PrintOps");
                }
                else if (sid.equals(Sid.BackupOps()))
                {
                    System.out.print("BackupOps");
                }
                else if (sid.equals(Sid.Replicator()))
                {
                    System.out.print("Replicator");
                }
                else if (sid.equals(Sid.RasServers()))
                {
                    System.out.print("RasServers");
                }
                else if (sid.equals(Sid.PreW2KAccess()))
                {
                    System.out.print("PreW2KAccess");
                }
                else
                {
                    System.out.print(sid.convertSidToStringSid());
                }

                System.out.print(" : ");

                // Check if the current group is enabled
                if ((value & SidAndAttributes.SE_GROUP_ENABLED) != 0)
                {
                    System.out.print("Enabled ");
                }
                if ((value & SidAndAttributes.SE_GROUP_ENABLED_BY_DEFAULT) != 0)
                {
                    System.out.print("EnabledByDefault ");
                }
                if ((value & SidAndAttributes.SE_GROUP_LOGON_ID) != 0)
                {
                    System.out.print("GroupLogonID ");
                }
                if ((value & SidAndAttributes.SE_GROUP_MANDATORY) != 0)
                {
                    System.out.print("Mandatory ");
                }
                if ((value & SidAndAttributes.SE_GROUP_OWNER) != 0)
                {
                    System.out.print("Owner ");
                }
                if ((value & SidAndAttributes.SE_GROUP_RESOURCE) != 0)
                {
                    System.out.print("GroupResource ");
                }
                if ((value & SidAndAttributes.SE_GROUP_USE_FOR_DENY_ONLY) != 0)
                {
                    System.out.print("GroupResourceForDenyOnly ");
                }
                System.out.println();
            }
        }
    }
}