/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
import com.jniwrapper.win32.registry.RegistryKey;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import com.jniwrapper.win32.registry.RegistryKeyType;
import com.jniwrapper.win32.registry.RegistryValueTransformer;
import com.jniwrapper.win32.system.Kernel32;
import com.jniwrapper.*;

import java.util.Iterator;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

public class RegistryKeyEnumValuesSample
{
    public static void main(String[] args)
    {
        // Let's registry keys with type EXPAND_SZ be expanded
        RegistryKeyValues.registerAssociation(RegistryKeyType.EXPAND_SZ, RegistryValueTransformer.STRING_EXPAND_TRANSFORMER);

        // CLSID\{F6D90F11-9C73-11D3-B32E-00C04F990BB4} means MS XML, should present on most Windows platforms
        RegistryKey CLSID =
                RegistryKey.CLASSES_ROOT.openSubKey("CLSID\\{F6D90F11-9C73-11D3-B32E-00C04F990BB4}\\InprocServer32", false);
        RegistryKeyValues values = CLSID.values();

        for (Iterator iterator = values.keySet().iterator(); iterator.hasNext();)
        {
            String keyName = (String) iterator.next();
            System.out.println(keyName + " = " + values.get(keyName).toString());
        }

        CLSID.close();
    }
}