/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32;

import com.jniwrapper.win32.Msg;

import java.util.EventListener;

/**
 * The listener interface for receiving events in the {@link MessageLoopThread} thread.
 *
 * @author Serge Piletsky
 */
public interface ProcessMessageListener extends EventListener
{
    /**
     * Invoked when the new message occures in the OLE message loop.
     * @param msg the occured message.
     *
     * @return true if message is processed else false
     */
    public boolean onMessage(Msg msg);
}