/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.dde;

/**
 * @author Vladimir Kondrashchenko
 */
public class DdeException extends Exception
{
    /**
     * The function succeeds
     */
    public static final int NO_ERROR = 0;
    /**
     * A request for a synchronous advise transaction has timed out.
     */
    public static final int ADVACKTIMEOUT = 0x4000;
    /**
     * 	The response to the transaction caused the DDE_FBUSY flag to be set.
     */
    public static final int BUSY = 0x4001;
    /**
     * A request for a synchronous data transaction has timed out.
     */
    public static final int DATAACKTIMEOUT = 0x4002;
    /**
     * A DDEML function was called without first calling the DdeInitialize function, or an invalid instance identifier was passed to a DDEML function.
     */
    public static final int DLL_NOT_INITIALIZED = 0x4003;
    /**
     * An application initialized as APPCLASS_MONITOR has attempted to perform a Dynamic Data Exchange (DDE)
     *  transaction, or an application initialized as APPCMD_CLIENTONLY has attempted to perform server transactions.
     */
    public static final int DLL_USAGE = 0x4004;
    /**
     * A request for a synchronous execute transaction has timed out.
     */
    public static final int EXECACKTIMEOUT = 0x4005;
    /**
     * A parameter failed to be validated by the DDEML.
     */
    public static final int INVALIDPARAMETER = 0x4006;
    /**
     * A DDEML application has created a prolonged race condition (in which the server application outruns the client),
     * causing large amounts of memory to be consumed.
     */
    public static final int LOW_MEMORY = 0x4007;
    /**
     * A memory allocation has failed.
     */
    public static final int MEMORY_ERROR = 0x4008;
    /**
     * A transaction has failed.
     */
    public static final int NOTPROCESSED = 0x4009;
    /**
     * Attempt of the client to establish a conversation has failed.
     */
    public static final int NO_CONV_ESTABLISHED = 0x400a;
    /**
     * A request for a synchronous poke transaction has timed out.
     */
    public static final int POKEACKTIMEOUT = 0x400b;
    /**
     * An internal call to the PostMessage function has failed.
     */
    public static final int POSTMSG_FAILED = 0x400c;
    /**
     * A synchronous transaction already in progress.
     */
    public static final int REENTRANCY = 0x400d;
    /**
     * A server-side transaction was attempted on a conversation terminated by the client.
     */
    public static final int SERVER_DIED = 0x400e;
    /**
     * An internal error has occurred in the DDEML.
     */
    public static final int SYS_ERROR = 0x400f;
    /**
     * A request to end an advise transaction has timed out.
     */
    public static final int UNADVACKTIMEOUT = 0x4010;
    /**
     * An invalid transaction identifier was passed to a DDEML function.
     */
    public static final int UNFOUND_QUEUE_ID = 0x4011;

    private int _errorCode;

    /**
     * Creates an instance of the class with the specified error code
     *
     * @param errorCode Error code
     */
    public DdeException(int errorCode)
    {
        super(getMessage(errorCode));
        _errorCode = errorCode;
    }

    /**
     * Creates an instance of the class with the specified error message.
     *
     * @param message Error message
     */
    public DdeException(String message)
    {
        super(message);
        _errorCode = -1;
    }

    /**
     * Returns the error code.
     *
     * @return the error code.
     */
    public int getErrorCode()
    {
        return _errorCode;
    }

    private static String getMessage(int errorcode)
    {
        String message = null;
        switch (errorcode)
        {
            case NO_ERROR :
                message = "No errors.";
                break;
            case ADVACKTIMEOUT :
                message = "A request for a synchronous advise transaction has timed out.";
                break;
            case BUSY :
                message = "The response to the transaction caused the DDE_FBUSY flag to be set.";
                break;
            case DATAACKTIMEOUT :
                message = "A request for a synchronous data transaction has timed out.";
                break;
            case DLL_NOT_INITIALIZED :
                message = "A DDEML function was called without first calling the DdeInitialize function.";
                break;
            case DLL_USAGE :
                message = "An application has attempted to perform illegal transaction.";
                break;
            case EXECACKTIMEOUT :
                message = "A request for a synchronous execute transaction has timed out.";
                break;
            case INVALIDPARAMETER :
                message = "A parameter failed to be validated by the DDEML.";
                break;
            case LOW_MEMORY :
                message = "Low memory.";
                break;
            case MEMORY_ERROR :
                message = "A memory allocation has failed.";
                break;
            case NOTPROCESSED :
                message = "A transaction has failed.";
                break;
            case NO_CONV_ESTABLISHED :
                message = "A client's attempt to establish a conversation has failed.";
                break;
            case POKEACKTIMEOUT :
                message = "A request for a synchronous poke transaction has timed out.";
                break;
            case POSTMSG_FAILED :
                message = "An internal call to the PostMessage function has failed.";
                break;
            case REENTRANCY :
                message = "A synchronous transaction already in progress.";
                break;
            case SERVER_DIED :
                message = "A server-side transaction was attempted on a conversation terminated by the client.";
                break;
            case SYS_ERROR :
                message = "An internal error has occurred in the DDEML.";
                break;
            case UNADVACKTIMEOUT :
                message = "A request to end an advise transaction has timed out.";
                break;
            case UNFOUND_QUEUE_ID :
                message = "An invalid transaction identifier was passed to a DDEML function.";
                break;
        }
        return message;
    }
}