/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.gdi.bitmap;

import com.jniwrapper.ArrayParameter;

import java.awt.Image;
import java.awt.image.BufferedImage;

/**
 * This provides functionality for building direct color bitmaps 
 */
public abstract class BitmapBuilderDirectColorModel extends BitmapBuilder
{
    // TODO [Sanders]: Remove if not needed.    
    private static final String INVALID_COLOR_MODEL_MSG = "This builder works with DirectColorModel only. CurrentModel = ";

    /**
     * Creates instance of the <code>BitmapBuilderDirectColorModel</code>
     *
     * @param bitCount The number of bits necessary for represent one pixel in the bitmap.
     * @param bufferedImage Buffer of image data.
     */
    protected BitmapBuilderDirectColorModel(int bitCount, BufferedImage bufferedImage)
    {
        super(bitCount, bufferedImage);

        checkColorModel();
    }

    /**
     * Returns Size of the color table
     *
     * @return The size of the bitmap color table
     */
    public int getColorTableSize()
    {
        return 0;
    }

    // TODO [Sanders]: Remove if not needed.
    private void checkColorModel()
    {
//        if (!(getColorModel() instanceof DirectColorModel))
//        {
//            throw new RuntimeException(INVALID_COLOR_MODEL_MSG + getColorModel());
//        }                                                                                     
    }

    /**
     * This method inherited from the base class {@link BitmapBuilder}. It is useless in this class and it do nothing.
     *
     * @param quadArray Array for storing elements of the color table.
     */
    public void buildColorTable(ArrayParameter quadArray)
    {
    }                    

    /**
     * Sets the colors of the all pixels in the bitmap
     */
    public void setBitmapColors()
    {
        int[] rgb = getBufferedImage().getRGB(0, 0, getWidth(), getHeight(), null, 0, getWidth());

        for (int x = 0; x < getWidth(); x++)
        {
            for (int y = 0; y < getHeight(); y++)
            {
                int argbColor = rgb[getImageOffset(x, y)];
                setArbgColor(argbColor, getOffsetInBitmapBytes(x, y));
            }
        }
    }

    /**
     * Sets the color of the specified pixel
     *
     * @param argbColor Color
     * @param offset Offset of the pixel in the bitmap bytes array 
     */
    public void setArbgColor(int argbColor, int offset)
    {
        setPixel(new ARGB(argbColor), offset);
    }

    /**
     * Sets the color of the specified pixel
     *
     * @param argb Color
     * @param offset Offeset of the pixel in the bitmap bytes array
     */
    public abstract void setPixel(ARGB argb, int offset);

    /**
     * This method always returns <code>null</code>
     * @return <code>null</code>
     *
     */
    public Image getTransparentMask()
    {
        return null;
    }
}