/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.hook;

import java.util.EventListener;

/**
 * The listener interface for receiving events from CBT {@link Hook} hook.
 */
public interface CBTHookListener extends EventListener
{
    /**
     * Specifies the event when the system is about to activate a window.
     *
     * @param event {@link com.jniwrapper.win32.hook.CBTEvent.Activate} event object
     */
    void activate(CBTEvent.Activate event);

    /**
     * Specifies the event when the system has removed a mouse message from the system message queue.
     * Upon receiving this hook code, a CBT application must install a WH_JOURNALPLAYBACK hook procedure in response
     * to the mouse message.
     *
     * @param event {@link com.jniwrapper.win32.hook.CBTEvent.ClickSkipped} event object
     */
    void clickSkipped(CBTEvent.ClickSkipped event);

    /**
     * Specifies the event when a window is about to be created.
     *
     * @param event {@link com.jniwrapper.win32.hook.CBTEvent.CreateWnd} event object
     */
    void createWnd(CBTEvent.CreateWnd event);

    /**
     * Specifies the event when a window is about to be destroyed.
     *
     * @param event {@link com.jniwrapper.win32.hook.CBTEvent.DestroyWnd} event object
     */
    void destroyWnd(CBTEvent.DestroyWnd event);

    /**
     * Specifies the event when the system has removed a keyboard message from the system message queue.
     *
     * @param event {@link com.jniwrapper.win32.hook.CBTEvent.KeySkipped} event object.
     */
    void keySkipped(CBTEvent.KeySkipped event);

    /**
     * Specifies the event when a window is about to be minimized or maximized.
     *
     * @param event {@link com.jniwrapper.win32.hook.CBTEvent.MinMax} event object
     */
    void minMax(CBTEvent.MinMax event);

    /**
     * Specifies the event when a window is about to be moved or sized.
     *
     * @param event {@link com.jniwrapper.win32.hook.CBTEvent.MoveSize} event object
     */
    void moveSize(CBTEvent.MoveSize event);

    /**
     * Specifies the event when the system has retrieved a WM_QUEUESYNC message from the system message queue.
     *
     * @param event {@link com.jniwrapper.win32.hook.CBTEvent.QS} event object
     */
    void qs(CBTEvent.QS event);

    /**
     * Specifies the event when a window is about to receive the keyboard focus.
     *
     * @param event {@link com.jniwrapper.win32.hook.CBTEvent.SetFocus} event object
     */
    void setFocus(CBTEvent.SetFocus event);

    /**
     * Specifies the event when a system command is about to be carried out. This allows a CBT application to prevent
     * task switching by means of hot keys.
     *
     * @param event {@link com.jniwrapper.win32.hook.CBTEvent.SysCommand} event object
     */
    void sysCommand(CBTEvent.SysCommand event);
}