/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.hook;

import com.jniwrapper.win32.Msg;

/**
 * This class describes events of the {@link
 * com.jniwrapper.win32.hook.Hook.Descriptor#GETMESSAGE} hook.
 * 
 * @author Serge Piletsky
 */
public class GetMsgEvent extends HookEventObject
{
    private boolean _isMessageRemoved;
    private Msg _msg;

    /**
     * Creates instance of the <code>GetMsgEvent</code>
     *
     * @param source The object on which the event initially occurred.
     * @param messageRemoved true if the message is removed. Otherwise false.
     * @param msg The message 
     */
    public GetMsgEvent(Object source, boolean messageRemoved, Msg msg)
    {
        super(source);
        _isMessageRemoved = messageRemoved;
        _msg = msg;
    }

    /**
     * Specifies whether the message is removed or not.
     *
     * @return true if the message is removed. Otherwise false.
     */
    public boolean isMessageRemoved()
    {
        return _isMessageRemoved;
    }

    /**
     * Returns the message.
     *
     * @return The message.
     */
    public Msg getMsg()
    {
        return _msg;
    }
}