package com.jniwrapper.win32.hook;

import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;

/**
 * This class represents the wrapper for <code>KBDLLHOOKSTRUCT</code> native structure.
 */
class KeyboardHookStruct extends Structure
{
    private UInt32 vkCode = new UInt32();
    private UInt32 scanCode = new UInt32();
    private UInt32 flags = new UInt32();
    private UInt32 time = new UInt32();
    private Pointer.Void extraInfo = new Pointer.Void();

    public KeyboardHookStruct()
    {
        init(new Parameter[]{vkCode, scanCode, flags, time, extraInfo}, (short) 8);
    }

    public UInt32 getVkCode()
    {
        return vkCode;
    }

    public UInt32 getScanCode()
    {
        return scanCode;
    }

    public UInt32 getFlags()
    {
        return flags;
    }

    public UInt32 getTime()
    {
        return time;
    }

    public Pointer.Void getExtraInfo()
    {
        return extraInfo;
    }

    public Object clone()
    {
        KeyboardHookStruct clone = new KeyboardHookStruct();
        clone.initFrom(this);
        return clone;
    }
}
