package com.jniwrapper.win32.hook;

import com.jniwrapper.Bool;
import com.jniwrapper.Pointer;

/**
 * Provides implementation of low-level keyboard hook.
 *
 * @author Serge Piletsky
 */
final public class LowLevelKeyboardHook extends LowLevelHook
{
    private KeyboardHookStruct keyboardData = new KeyboardHookStruct();
    private Pointer structurePointer = new Pointer(keyboardData);

    public LowLevelKeyboardHook()
    {
        super(Descriptor.KEYBOARD_LL);
    }

    protected long processEvent(long wParam, long lParam)
    {
        if (lParam != 0)
        {
            Pointer.Void structureHandle = new Pointer.Void(lParam);
            structureHandle.castTo(structurePointer);
            Bool consume = new Bool(false);
            LowLevelKeyboardEvent event = new LowLevelKeyboardEvent(this, wParam, keyboardData, consume);
            notifyListeners(event);
            if (consume.getValue())
            {
                return CONSUME_ACTION;
            }
            else
            {
                return 0;
            }
        }
        else
        {
            return 0;
        }
    }
}
