/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.hook.data;

import com.jniwrapper.AnsiString;
import com.jniwrapper.Structure;
import com.jniwrapper.Bool;
import com.jniwrapper.win32.Handle;

/**
 * @author Serge Piletsky
 */
abstract class AbstractHookData extends Structure
{
    protected Handle _hookHandle = new Handle();
    protected Bool _syncronous = new Bool(false);
    protected AnsiString _eventDescriptor = new AnsiString(40);

    public String getEventDescriptor()
    {
        return _eventDescriptor.getValue();
    }

    public void setSyncronous(boolean syncronous) {
        _syncronous.setValue(syncronous);
    }

    public boolean isSyncronous() {
        return _syncronous.getValue();
    }
}