/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.hook.data;

import com.jniwrapper.Bool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.win32.ui.Wnd;

/**
 * This class represents the wrapper for the <code>CBTACTIVATESTRUCT</code> structure.
 *
 * @see <a href="http://msdn.microsoft.com/en-us/library/ms644961(VS.85).aspx">Microsoft COM SDK documentation</a>
 */
class CBTACTIVATESTRUCT extends Structure
{
    private Bool fMouse = new Bool();
    private Wnd hWndActive = new Wnd();

    public CBTACTIVATESTRUCT()
    {
        init(new Parameter[]{fMouse, hWndActive}, (short) 8);
    }

    public Bool getFMouse()
    {
        return fMouse;
    }

    public Wnd getHWndActive()
    {
        return hWndActive;
    }
}