/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.hook.data;

import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.win32.IntPtr;
import com.jniwrapper.win32.hook.EventsFilter;

/**
 * @author Serge Piletsky
 */
class WndProcHookData extends AbstractHookData
{
    private IntPtr wParam = new IntPtr();
    private CWndProcStructure cwpStruct = new CWndProcStructure();
    private EventsFilterStucture eventsFilterStucture = new EventsFilterStucture();
    private EventsFilter filter;

    WndProcHookData()
    {
        init(new Parameter[]{_hookHandle, _syncronous, _eventDescriptor, wParam, cwpStruct, eventsFilterStucture}, (short) 1);
    }

    long getwParam()
    {
        return wParam.getValue();
    }

    CWndProcStructure getCwpStruct()
    {
        return cwpStruct;
    }

    public void setFilter(EventsFilter filter)
    {
        if (filter == null)
        {
            throw new IllegalArgumentException("Invalid events filter");
        }

        this.filter = filter;
        eventsFilterStucture.applyEventsFilter(filter);
    }

    public EventsFilter getFilter()
    {
        return filter;
    }
}