/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.io;

/**
 * FileInfo class is a file information container.
 * 
 * @author Serge Piletsky
 */
public class FileInfo
{
    private String _fileName;
    private long _attributes;
    private long _size;
    private long _lastModified;

    /**
     * Creates instance of the <code>FileInfo</code> class with specified file name,
     * file attributes, file size end date of the last modification
     *
     * @param fileName File name
     * @param attributes File attributes
     * @param size File size
     * @param lastModified The date of last modification
     */
    public FileInfo(String fileName, long attributes, long size, long lastModified)
    {
        _fileName = fileName;
        _attributes = attributes;
        _size = size;
        _lastModified = lastModified;
    }

    /**
     * Creates instance of the <code>FileInfo</code> class with specified file name.
     *
     * @param fileName File name
     */
    public FileInfo(String fileName)
    {
        _fileName = fileName;
    }

    /**
     * Returns file name
     *
     * @return The file name
     */
    public String getFileName()
    {
        return _fileName;
    }

    /**
     * Returns file attributes
     *
     * @return The file attributes
     */
    public long getAttributes()
    {
        return _attributes;
    }

    /**
     * Returns file size
     *
     * @return File size
     */
    public long getSize()
    {
        return _size;
    }

    /**
     * Returns date of the last modification
     *
     * @return Date of the last modification
     */
    public long getLastModified()
    {
        return _lastModified;
    }

    /**
     * Returns string representation of the object - name of the file
      * @return String representation of the object - name of the file
     */
    public String toString()
    {
        return getFileName();
    }
}