/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.io;

import com.jniwrapper.win32.LastError;

/**
 * FileSystemException class is an exception that can be thrown by
 * FileSystemWatcher at startup or during watching file system events.
 * 
 * @author Serge Piletsky
 */
public class FileSystemException extends RuntimeException
{
    /**
     * @deprecated Use another constructor {@link #FileSystemException(int)} instead.
     */
    public FileSystemException()
    {
        super(LastError.getMessage());
    }

    public FileSystemException(int errorCode)
    {
        super(LastError.getMessage(errorCode));
    }

    public FileSystemException(String s)
    {
        super(s);
    }
}