/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.security;

import com.jniwrapper.LongInt;
import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;

/**
 * The opaque structure that represents native <code>LUID</code> structure.
 * <a href = "http://msdn.microsoft.com/en-us/library/aa379261.aspx"> LUID structure in MSDN Library </a>.
 */
public class Luid extends Structure
{
    private UInt32 _lowPart = new UInt32();
    private LongInt _highPart = new LongInt();

    /**
     * Creates instance of the <code>Luid</code> that represents 64-bit value guaranteed to be unique only on the system on which it was generated.
     * The uniqueness of a locally unique identifier (LUID) is guaranteed only until the system is restarted.
     */
    public Luid()
    {
        init(new Parameter[]{_lowPart, _highPart});
    }

    /**
     * Creates new instanceof the <code>LUID</code> and initializes it by the specified one.
     *
     * @param other The value that will be used to initialize created instance.
     */
    private Luid(Luid other)
    {
        this();
        _lowPart.setValue(other._lowPart.getValue());
        _highPart.setValue(other._highPart.getValue());
    }

    /**
     * Creates copy of this instance.
     *
     * @return The copy of this instance.
     */
    public Object clone()
    {
        return new Luid(this);
    }
}