/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.security;

import com.jniwrapper.*;

/**
 * This class is the wrapper for the SID_AND_ATTRIBUTES structure.
 * (@see <a href="http://msdn.microsoft.com/library/default.asp?url=/library/en-us/secauthz/security/sid_and_attributes.asp">
 * SID_AND_ATTRIBUTES structure</a>).
 *
 * @author Alexei Razoryonov
 */

public class SidAndAttributes extends Structure
{
    /**
     * The SID is enabled for access checks. When the system performs an access check, it checks for access-allowed and access-denied access control entries (ACEs) that apply to the SID.
     * A SID without this attribute is ignored during an access check unless the SE_GROUP_USE_FOR_DENY_ONLY attribute is set.
     */
    public static long SE_GROUP_ENABLED = 0x00000004L;
    /**
     * The SID is enabled by default.
     */
    public static long SE_GROUP_ENABLED_BY_DEFAULT = 0x00000002L;
    /**
     * The SID is a logon SID that identifies the logon session associated with an access token.
     */
    public static long SE_GROUP_LOGON_ID = 0xC0000000L;

    /**
     * The SID cannot have the SE_GROUP_ENABLED attribute cleared by a call to the AdjustTokenGroups function. However, you can use the CreateRestrictedToken function to convert a mandatory SID to a deny-only SID.
     */
    public static long SE_GROUP_MANDATORY = 0x00000001L;

    /**
     * The SID identifies a group account for which the user of the token is the owner of the group, or the SID can be assigned as the owner of the token or objects.
     */
    public static long SE_GROUP_OWNER = 0x00000008L;

    /**
     * The SID identifies a domain-local group.
     * Windows NT:  This value is not supported.
     */
    public static long SE_GROUP_RESOURCE = 0x20000000L;

    /**
     * The SID is a deny-only SID in a restricted token. When the system performs an access check, it checks for access-denied ACEs that apply to the SID; it ignores access-allowed ACEs for the SID.
     * If this attribute is set, SE_GROUP_ENABLED is not set, and the SID cannot be reenabled.
     * Windows NT:  This value is not supported. 
     */
    public static long SE_GROUP_USE_FOR_DENY_ONLY = 0x00000010L;

    private Sid sid = new Sid();
    private Pointer _pSid = new Pointer(sid);
    private UInt32 _attributes = new UInt32();

    public SidAndAttributes()
    {
        init(new Parameter[]{_pSid, _attributes}, (short) 8);
    }

    /**
     * @deprecated use getSid() instead
     */
    public Pointer getpSid()
    {
        return new Pointer(_pSid);
    }

    /**
     * @deprecated use getSid() instead
     */
    public void setpSid(Pointer pSid)
    {
        sid.initFrom((Structure) pSid.getReferencedObject());
    }

    /**
     * @return SID
     */
    public Sid getSid()
    {
        return sid;
    }

    /**
     * @return SID attributes
     */
    public UInt32 getAttributes()
    {
        return _attributes;
    }

    public void setAttributes(UInt32 attributes)
    {
        _attributes.setValue(attributes.getValue());
    }

    public Object clone()
    {
        SidAndAttributes clone = new SidAndAttributes();
        clone.initFrom(this);
        return clone;
    }
}