/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */

package com.jniwrapper.win32.security;

import com.jniwrapper.*;

/**
 * This class is the SID_IDENTIFIER_AUTHORITY structure wrapper.
 * (@see <a href="http://msdn.microsoft.com/library/default.asp?url=/library/en-us/secauthz/security/sid_identifier_authority.asp">
 * SSID_IDENTIFIER_AUTHORITY structure</a>).
 *
 * @author Alexei Razoryonov
 */
public class SidIdentifierAuthority extends Structure
{
    public static SidIdentifierAuthority SECURITY_NULL_SID_AUTHORITY = new SidIdentifierAuthority(new char[] {0,0,0,0,0,0});
    public static SidIdentifierAuthority SECURITY_WORLD_SID_AUTHORITY = new SidIdentifierAuthority(new char[] {0,0,0,0,0,1});
    public static SidIdentifierAuthority SECURITY_LOCAL_SID_AUTHORITY = new SidIdentifierAuthority(new char[] {0,0,0,0,0,2});
    public static SidIdentifierAuthority SECURITY_CREATOR_SID_AUTHORITY = new SidIdentifierAuthority(new char[] {0,0,0,0,0,3});
    public static SidIdentifierAuthority SECURITY_NON_UNIQUE_AUTHORITY = new SidIdentifierAuthority(new char[] {0,0,0,0,0,4});
    public static SidIdentifierAuthority SECURITY_NT_AUTHORITY = new SidIdentifierAuthority(new char[] {0,0,0,0,0,5});
    public static SidIdentifierAuthority SECURITY_RESOURCE_MANAGER_AUTHORITY = new SidIdentifierAuthority(new char[] {0,0,0,0,0,9});
    
    private PrimitiveArray _value = new PrimitiveArray(Char.class, 6);

    public SidIdentifierAuthority()
    {
        init(new Parameter[]{_value}, (short) 8);
    }

    private SidIdentifierAuthority(char[] values)
    {
        this();

        // Initialize members explicitly
        for (int i=0; i<6; ++i)
        {
            _value.setElement(i, new Char(values[i]));
        }
    }

    public PrimitiveArray getValue()
    {
        return _value;
    }

    /**
     * @deprecated should not be used anymore.     
     */
    public void setValue(PrimitiveArray value)
    {
    }

    public Object clone()
    {
        SidIdentifierAuthority authority = new SidIdentifierAuthority();
        authority.initFrom(this);
        return authority;
    }
}