/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Function;
import com.jniwrapper.win32.WinFunctionCache;

/**
 * This class provides functions from Advapi32 library.
 *
 * @author Serge Piletsky
 */
public class AdvApi32 extends WinFunctionCache
{
    static final String LIBRARY_NAME = "Advapi32";

    private static AdvApi32 _instance;

    protected AdvApi32()
    {
        super(LIBRARY_NAME);
    }

    public static AdvApi32 getInstance()
    {
        if (_instance == null)
        {
            _instance = new AdvApi32();
        }
        return _instance;
    }

    public static Function get(Object functionName)
    {
        return getInstance().getFunction(functionName.toString());
    }
}