/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.*;
import com.jniwrapper.win32.SizeT;
import com.jniwrapper.win32.LastErrorException;

/**
 * This class represents the wrapper for <code>MEMORYSTATUS</code> structure.
 *
 * Use {@link MemoryInfo} class to obtain memory information.
 *
 * @author Serge Piletsky
 */
public class MemoryStatus extends Structure
{
    static final String FUNCTION_GET_MEMORY_STATUS = "GlobalMemoryStatus";

    private UInt32 _length = new UInt32();
    private UInt32 _memoryLoad = new UInt32();
    private SizeT _totalPhys = new SizeT();
    private SizeT _availPhys = new SizeT();
    private SizeT _totalPageFile = new SizeT();
    private SizeT _availPageFile = new SizeT();
    private SizeT _totalVirtual = new SizeT();
    private SizeT _availVirtual = new SizeT();

    /**
     * Creates new instance & reads information using <code>GlobalMemoryStatus</code> function.
     * 
     * @deprecated Use {@link MemoryInfo} class to obtain memory information. 
     */
    public MemoryStatus()
    {
        init(new Parameter[]
        {
            _length,
            _memoryLoad,
            _totalPhys,
            _availPhys,
            _totalPageFile,
            _availPageFile,
            _totalVirtual,
            _availVirtual
        });
        _length.setValue(this.getLength());

        Function globalMemoryStatus = Kernel32.getInstance().getFunction(FUNCTION_GET_MEMORY_STATUS);
        globalMemoryStatus.invoke(null, new Pointer(this));
    }

    public long getMemoryLoad()
    {
        return _memoryLoad.getValue();
    }

    public long getTotalPhys()
    {
        return _totalPhys.getValue();
    }

    public long getAvailPhys()
    {
        return _availPhys.getValue();
    }

    public long getTotalPageFile()
    {
        return _totalPageFile.getValue();
    }

    public long getAvailPageFile()
    {
        return _availPageFile.getValue();
    }

    public long getTotalVirtual()
    {
        return _totalVirtual.getValue();
    }

    public long getAvailVirtual()
    {
        return _availVirtual.getValue();
    }

    public Object clone()
    {
        MemoryStatus clone = new MemoryStatus();
        clone.initFrom(this);
        return clone;
    }
}