/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.*;
import com.jniwrapper.win32.LastErrorException;

/**
 * This class represents the wrapper for <code>MEMORYSTATUSEX</code> structure.
 *
 * Use {@link MemoryInfo} class to obtain memory information.
 *  
 * @author Vadim Ridosh
 */
public class MemoryStatusEx extends Structure
{

    static final String FUNCTION_GET_MEMORY_STATUS_EX = "GlobalMemoryStatusEx";

    private UInt32 _length = new UInt32();
    private UInt32 _memoryLoad = new UInt32();
    private UInt64 _totalPhys = new UInt64();
    private UInt64 _availPhys = new UInt64();
    private UInt64 _totalPageFile = new UInt64();
    private UInt64 _availPageFile = new UInt64();
    private UInt64 _totalVirtual = new UInt64();
    private UInt64 _availVirtual = new UInt64();
    private UInt64 _availExtendedVirtual = new UInt64();

    /**
     * Creates an instance with information on the current memory state.
     */
    public MemoryStatusEx()
    {
        init(new Parameter[]
        {
            _length,
            _memoryLoad,
            _totalPhys,
            _availPhys,
            _totalPageFile,
            _availPageFile,
            _totalVirtual,
            _availVirtual,
            _availExtendedVirtual
        });
        _length.setValue(this.getLength());

        Function globalMemoryStatus = Kernel32.getInstance().getFunction(FUNCTION_GET_MEMORY_STATUS_EX);
        Bool result = new Bool();
        long errorCode = globalMemoryStatus.invoke(result, new Pointer(this));
        if (!result.getValue())
        {
            throw new LastErrorException(errorCode);
        }
    }

    /**
     * Creates an instance of the <code>MemoryStatusEx</code> from the specified value
     *
     * @param that 
     */
    public MemoryStatusEx(MemoryStatusEx that)
    {
        this();
        initFrom(that);
    }

    public long getMemoryLoad()
    {
        return _memoryLoad.getValue();
    }

    public long getTotalPhys()
    {
        return _totalPhys.getValue();
    }

    public long getAvailPhys()
    {
        return _availPhys.getValue();
    }

    public long getTotalPageFile()
    {
        return _totalPageFile.getValue();
    }

    public long getAvailPageFile()
    {
        return _availPageFile.getValue();
    }

    public long getTotalVirtual()
    {
        return _totalVirtual.getValue();
    }

    public long getAvailVirtual()
    {
        return _availVirtual.getValue();
    }

    public long getAvailExtendedVirtual()
    {
        return _availExtendedVirtual.getValue();
    }

    public Object clone()
    {
        MemoryStatusEx clone = new MemoryStatusEx();
        clone.initFrom(this);
        return clone;
    }
}