/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Function;

/**
 * This class provides access to the desktop window. The desktop window covers the entire screen.
 * The desktop window is the area on top of which other windows are painted.
 * 
 * @author Alexander Evsukov
 */

public class DesktopWindow extends Wnd
{
    static final String FUNCTION_GET_DESKTOP_WINDOW = "GetDesktopWindow";

    private DesktopWindow()
    {
    }

    /**
     * Returns a handle to the desktop window.
     *
     * @return Handle to the desktop window.
     */
    public static DesktopWindow getInstance()
    {
        DesktopWindow hDesktop = new DesktopWindow();
        final Function function = User32.getInstance().getFunction(FUNCTION_GET_DESKTOP_WINDOW);
        function.invoke(hDesktop);
        return hDesktop;
    }
}