/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.ui;

import java.util.EventListener;

/**
 * WindowMessageListener interface.
 * 
 * @author Serge Piletsky
 */
public interface WindowMessageListener extends EventListener
{
    /**
     * Tests if the listener can handle a specified message.
     * 
     * @param message
     * @param beforeWindowProc the flag specifies that the event occurred before
     * or after window procedure.
     * @return true if the message can be processed; otherwise false.
     */
    public boolean canHandle(WindowMessage message, boolean beforeWindowProc);

    /**
     * Handles window message.
     * 
     * @param message
     * @return the result of message processing.
     */
    public int handle(WindowMessage message);
}