//
//  MPAbstractButton.h
//  MPServices
//
//  Created by Oleksii Dykan on 8/18/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MPControl.h"

typedef enum {
	MPButtonTextAlignementLeft = 0,
	MPButtonTextAlignementRight = 1,
	MPButtonTextAlignementCenter = 2,
} MPButtonTextAlignement;

typedef enum
{
	MPButtonBehaviorState = 0, // Выбираем это, если надо режим включено/выключено
	MPButtonBehaviorMomentary = 1,
	MPButtonBehaviorPushable = 2,
    MPButtonBehaviorStateOnMouseUp = 3,
    MPButtonBehaviorStateOnMouseUpWithPush = 4,
    MPButtonBehaviorStateMouseDown = 5,
} MPButtonBehavior;

typedef enum MPBorderStyle {
	MPBorderStyle1,
	MPBorderStyle2
} MPBorderStyle;

typedef enum
{
    MPButtonPictogramPositionTop,
    MPButtonPictogramPositionBottom,
    MPButtonPictogramPositionLeft,
    MPButtonPictogramPositionRight,
    MPButtonPictogramPositionCenter,
    MPButtonPictogramPositionRightMost,
} MPButtonPictogramPosition;

@interface MPAbstractButton : MPControl

@property(nonatomic, strong) NSImage *normalStateImage;
@property(nonatomic, strong) NSImage *pushedStateImage;
@property(nonatomic, strong) NSImage *mouseOverImage;
@property(nonatomic, strong) NSImage *disabledStateImage;
@property(nonatomic, strong) NSImage *pictogram;
@property(nonatomic, strong) NSImage *pushedPictogram;
@property(nonatomic, strong) NSImage *mouseOverPictogram;
@property(nonatomic, strong) NSImage *disabledPictogram;
@property(nonatomic, assign) BOOL acceptKeyDown;
@property(nonatomic, assign) BOOL pressed;

@property(nonatomic, assign) IBInspectable CGPoint textOffset;
@property(nonatomic, assign) IBInspectable CGPoint pictogramOffset;
@property(nonatomic, strong) IBInspectable NSString* keyEquivalent;
@property(nonatomic, assign) IBInspectable NSUInteger keyCode;
@property(nonatomic, assign) IBInspectable NSUInteger keyEquivalentModifierFlags;

@property(nonatomic, strong) IBInspectable NSString *mouseOverStateImageName;
@property(nonatomic, strong) IBInspectable NSString *normalStateImageName;
@property(nonatomic, strong) IBInspectable NSString *pushedStateImageName;
@property(nonatomic, strong) IBInspectable NSString *disabledStateImageName;
@property(nonatomic, strong) IBInspectable NSString *pictogramName;
@property(nonatomic, strong) IBInspectable NSString *pushedPictogramName;
@property(nonatomic, strong) IBInspectable NSString *mouseOverPictogramName;
@property(nonatomic, strong) IBInspectable NSString *disabledPictogramName;

@property(nonatomic, strong) IBInspectable NSString *normalStateThreeImageName;
@property(nonatomic, strong) IBInspectable NSString *pushedStateThreeImageName;
@property(nonatomic, strong) IBInspectable NSString *mouseOverStateThreeImageName;
@property(nonatomic, strong) IBInspectable NSString *disabledStateThreeImageName;
// Need add nine part image name and implement it

@property(nonatomic, strong) IBInspectable NSString *fontName;
@property(nonatomic, assign) NSLineBreakMode attributedLineBreakMode;
@property(nonatomic, assign) BOOL defaultTighteningForTruncation;

@property (nonatomic, copy) IBInspectable NSString *bundleIdentifier;

- (void)commonInit;
- (void)sizeToFit;

- (void)setNormalStateImageWithImages:(NSImage *)leftImage centerImage:(NSImage *)centerImage rightImage:(NSImage *)rightImage;
- (void)setNormalStateImageWithImageNames:(NSString *)leftImageName center:(NSString *)centerImageName right:(NSString *)rightImageName;

- (void)setPushedStateImageWithImages:(NSImage *)leftImage centerImage:(NSImage *)centerImage rightImage:(NSImage *)rightImage;
- (void)setPushedStateImageWithImageNames:(NSString *)leftImageName center:(NSString *)centerImageName right:(NSString *)rightImageName;

- (void)setMouseOverStateImageWithImages:(NSImage *)leftImage centerImage:(NSImage *)centerImage rightImage:(NSImage *)rightImage;
- (void)setMouseOverStateImageWithImageNames:(NSString *)leftImageName center:(NSString *)centerImageName right:(NSString *)rightImageName;

- (void)setDisabledStateImageWithImages:(NSImage *)leftImage centerImage:(NSImage *)centerImage rightImage:(NSImage *)rightImage;
- (void)setDisabledStateImageWithImageNames:(NSString *)leftImageName center:(NSString *)centerImageName right:(NSString *)rightImageName;

@property(nonatomic, copy) IBInspectable NSString *title;

@property(nonatomic, strong) IBInspectable NSColor *fontColor;
@property(nonatomic, strong) IBInspectable NSColor *selectedFontColor;
@property(nonatomic, strong) IBInspectable NSColor *mouseOverFontColor;
@property(nonatomic, strong) IBInspectable NSColor *disabledFontColor;
@property(nonatomic, assign) IBInspectable CGFloat fontSize;
@property(nonatomic, assign) IBInspectable CGFloat kerning;
/// If set to YES, ignores fontName and uses +[NSFont systemFontOfSize:]. Default is NO.
@property(nonatomic) IBInspectable BOOL useSystemFont;
@property(nonatomic, strong) NSShadow *shadow;
@property(nonatomic, assign) IBInspectable NSSize shadowOffset;
@property(nonatomic, assign) IBInspectable CGFloat additionalSpace;

@property(nonatomic, strong) id representedObject;

@property(nonatomic, assign) IBInspectable BOOL highlightOnMouseDown;

@property(nonatomic, assign) BOOL pushed;
@property(nonatomic, assign) IBInspectable MPButtonTextAlignement alignment;
@property(nonatomic, assign) IBInspectable NSTextAlignment multilineAlignment;
@property(nonatomic, assign) IBInspectable MPButtonPictogramPosition pictogramPosition;

@property(nonatomic, assign) IBInspectable MPBorderStyle borderStyle;
@property(nonatomic, assign) IBInspectable MPButtonBehavior behavior;
@property(nonatomic, assign) IBInspectable BOOL bordered;
@property(nonatomic, assign) IBInspectable BOOL imageFitToBounds;

@property(nonatomic, assign) IBInspectable CGFloat titleRightInset;
@property(nonatomic, assign) IBInspectable CGFloat minTextOffset;

@property (nonatomic, assign) IBInspectable BOOL userInteractionEnabled;

@property (nonatomic, assign) IBInspectable BOOL shouldLocalize;

@property (nonatomic, assign) IBInspectable BOOL showPointingHandCursorOnMouseOver;
@property (nonatomic, assign) IBInspectable BOOL underlinedTitle;

@property (nonatomic, assign) IBInspectable NSUInteger maxClickCount;
@property (nonatomic, assign) IBInspectable BOOL listenKeyUp;
@property (nonatomic, assign) IBInspectable BOOL alwaysPassKeyEquvalent;
@property (nonatomic, assign) IBInspectable BOOL passMouseUpDownEventsToSuper;
@property (nonatomic, assign) IBInspectable BOOL passMouseDraggedToSuper;

@property (nonatomic, copy) IBInspectable NSString *hyperlink;

@property (copy) void (^mouseEnteredCallback)(MPAbstractButton *);
@property (copy) void (^mouseExitedCallback)(MPAbstractButton *);

+ (CGFloat)defaultFontSize;
+ (void)setDefaultFontSize:(CGFloat)fontSize;

+ (NSColor *)defaultFontColor;
+ (void)setDefaultFontColor:(NSColor *)fontColor;

+ (NSColor *)defaultSelectedFontColor;
+ (void)setDefaultSelectedFontColor:(NSColor *)selectedFontColor;

+ (NSString *)defaultFontName;
+ (void)setDefaultFontName:(NSString *)fontName;

+ (BOOL)defaultUseSystemFont;
+ (void)setDefaultUseSystemFont:(BOOL)useSystemFont;

+ (MPButtonBehavior)defaultBehaviour;
+ (void)setDefaultBehaviour:(MPButtonBehavior)behaviour;

+ (MPButtonTextAlignement)defaultTextAlignment;
+ (void)setDefaultTextAlignment:(MPButtonTextAlignement)textAlignment;

+ (NSTextAlignment)defaultMultilineTextAlignment;
+ (void)setDefaultMultilineTextAlignment:(NSTextAlignment)textAlignment;

+ (MPButtonPictogramPosition)defaultPictogramPosition;
+ (void)setDefaultPictogramPosition:(MPButtonPictogramPosition)pictogramPosition;

+ (BOOL)defaultButtonEnabled;
+ (void)setDefaultButtonEnabled:(BOOL)enabled;

+ (BOOL)defaultButtonBordered;
+ (void)setDefaultButtonBordered:(BOOL)bordered;

+ (BOOL)defaultImageFitToBounds;
+ (void)setDefaultImageFitToBounds:(BOOL)imageFitToBounds;

+ (CGPoint)defaultTextOffset;
+ (void)setDefaultTextOffset:(CGPoint)offset;

+ (CGPoint)defaultPictogramOffset;
+ (void)setDefaultPictogramOffset:(CGPoint)offset;

+ (NSSize)defaultShadowOffset;
+ (void)setDefaultShadowOffset:(NSSize)shadowOffset;

+ (CGFloat)defaultAdditionalSpace;
+ (void)setDefaultAdditionalSpace:(CGFloat)addSpace;

+ (CGFloat)defaultMinTextOffset;
+ (void)setDefaultMinTextOffset:(CGFloat)minTextOffset;

@end
