//
//  MPBatchOptions.h
//  Phoenix
//
//  Created by Oleksii Dykan on 6/2/15.
//  Copyright (c) 2015 MacPhun LLC. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MPBatchProcessing.h"

@class MPBatchNamingOptions;


typedef enum : NSUInteger {
    MPBatchOptionsSizeToFitOriginal,
    MPBatchOptionsSizeToFitLongEdge,
    MPBatchOptionsSizeToFitShortEdge,
    MPBatchOptionsSizeToFitDimensions,
} MPBatchOptionsSizeToFit;

typedef enum : NSUInteger {
    MPBatchOptionsNamingTypeNone,
    MPBatchOptionsNamingTypeFileName,
    MPBatchOptionsNamingTypeCustomString,
    MPBatchOptionsNamingTypeCounter,
    MPBatchOptionsNamingTypeTimestamp,
} MPBatchOptionsNamingType;

typedef enum : NSUInteger {
    MPBatchOptionsLettersTypeOriginal,
    MPBatchOptionsLettersTypeUppercase,
    MPBatchOptionsLettersTypeLowercase,
} MPBatchOptionsLettersType;

typedef enum : NSUInteger {
    MPBatchOptionsTimestampTypeDDMMYYYY,
    MPBatchOptionsTimestampTypeYYYYMMDD,
    MPBatchOptionsTimestampTypeDD_MM_YYYY,
    MPBatchOptionsTimestampTypeYYYY_MM_DD,
} MPBatchOptionsTimestampType;


@interface MPBatchOptions : NSObject <NSCoding, NSCopying>

@property (nonatomic, copy) NSString *name;

@property (nonatomic, assign) BOOL askForPermission;
@property (nonatomic, assign) BOOL chooseFolder;
@property (nonatomic, copy) NSString *outputFolderPath;
@property (nonatomic, copy) NSString *saveType;
@property (nonatomic, assign) NSInteger tiffCompression;
@property (nonatomic, assign) NSInteger depth;
@property (nonatomic, assign) CGFloat compressionQuality;
@property (nonatomic, assign) MPBatchColorSpaceType colorSpaceType;

@property (nonatomic, assign) MPBatchOptionsSizeToFit sizeToFitType;
@property (nonatomic, assign) CGFloat longEdge;
@property (nonatomic, assign) CGFloat shortEdge;
@property (nonatomic, assign) NSSize dimensions;
@property (nonatomic, assign) BOOL doNotEnlarge;

@property (nonatomic, strong) MPBatchNamingOptions *prefixNamingOptions;
@property (nonatomic, strong) MPBatchNamingOptions *baseNameNamingOptions;
@property (nonatomic, strong) MPBatchNamingOptions *suffixNamingOptions;

@property (nonatomic, assign) MPBatchOptionsLettersType lettersType;

@property (nonatomic, copy) NSDictionary *imageProcessingSettings;

- (NSString *)properFileNameFromName:(NSString *)originalFileName withIndex:(NSUInteger)idx;

@property (nonatomic, assign) BOOL saveOutputPath;

@end

@interface MPBatchNamingOptions : NSObject <NSCoding, NSCopying>

@property (nonatomic, assign) MPBatchOptionsNamingType namingType;

@property (nonatomic, copy) NSString *stringValue;
@property (nonatomic, assign) NSInteger counterStartValue;
@property (nonatomic, assign) MPBatchOptionsTimestampType timestampType;

+ (id)namingOptionsWithDefaultNamingType:(MPBatchOptionsNamingType)defaultNamingType;

@end
