//
//  MPEmailConfirmation.h
//  FXPhotoStudioMac
//
//  Created by Chemersky on 3/9/16.
//
//

#import <Foundation/Foundation.h>


typedef enum {
    MPEmailConfirmationStatusNotSend,
    MPEmailConfirmationStatusWaiting,
    MPEmailConfirmationStatusConfirmed
} MPEmailConfirmationStatus;


@interface MPEmailConfirmation : NSObject

/*!
 * @brief application identifier for sign up handling
 */
@property (copy, nonatomic) NSString *paramAppId;

+ (MPEmailConfirmationStatus)confirmationStatus;
+ (void)saveSharedData:(NSDictionary *)data;
+ (NSDictionary *)sharedData;

- (void)sendEmail:(NSString *)email withName:(NSString *)name confirmationEnabled:(BOOL)confirmationEnabled callbackBlock:(void (^)(NSString *error))callback;
- (void)requestForConfirmationStatus;

@end

extern NSString * const kMPEmailConfirmationDidConfirmNotification;
