

#import <Foundation/Foundation.h>
#import <Security/Security.h>


#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wobjc-missing-property-synthesis"


#import <TargetConditionals.h>
#ifndef MPKeychain_USE_NSCODING
#if TARGET_OS_IPHONE
#define MPKeychain_USE_NSCODING 1
#else
#define MPKeychain_USE_NSCODING 0
#endif
#endif


typedef NS_ENUM(NSInteger, MPKeychainAccess)
{
    MPKeychainAccessibleWhenUnlocked = 0,
    MPKeychainAccessibleAfterFirstUnlock,
    MPKeychainAccessibleAlways,
    MPKeychainAccessibleWhenUnlockedThisDeviceOnly,
    MPKeychainAccessibleAfterFirstUnlockThisDeviceOnly,
    MPKeychainAccessibleAlwaysThisDeviceOnly
};


@interface MPKeychain : NSObject

+ (nonnull instancetype)defaultKeychain;

@property (nonatomic, readonly, nullable) NSString *service;
@property (nonatomic, readonly, nullable) NSString *accessGroup;
@property (nonatomic, assign) MPKeychainAccess accessibility;

- (nonnull id)initWithService:(nullable NSString *)service
                  accessGroup:(nullable NSString *)accessGroup
                accessibility:(MPKeychainAccess)accessibility;

- (nonnull id)initWithService:(nullable NSString *)service
                  accessGroup:(nullable NSString *)accessGroup;

- (BOOL)setObject:(nullable id)object forKey:(nonnull id)key;
- (BOOL)setObject:(nullable id)object forKeyedSubscript:(nonnull id)key;
- (BOOL)removeObjectForKey:(nonnull id)key;
- (nullable id)objectForKey:(nonnull id)key;
- (nullable id)objectForKeyedSubscript:(nonnull id)key;

@end


#pragma GCC diagnostic pop

