//
//  MPSPluginsInstaller.h
//  Memphis
//
//  Created by yurk on 11/19/13.
//  Copyright (c) 2013 MacPhun LLC. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MPSInstallPluginsUtils.h"


static NSString * const MPSPluginsInstallerAppSupportSubfolderName = @"MacPhun Software";
static NSString * const MPSPluginsInstallerPluginsFolderName = @"Plug-Ins";
static NSString * const MPSPluginsInstallerPSPluginExtension = @"plugin";


@interface MPSPluginsInstaller : NSObject

@property (assign, getter = isPhotoshopPluginInstalled) BOOL photoshopPluginInstalled;
@property (assign, getter = isPhotoshopInstalled) BOOL photoshopInstalled;
@property (assign, getter = isLightroomPluginInstalled) BOOL lightroomPluginInstalled;
@property (assign, getter = isLightroomInstalled) BOOL lightroomInstalled;
@property (assign, getter = isApertureInstalled) BOOL apertureInstalled;
@property (assign, getter = isAperturePluginInstalled) BOOL aperturePluginInstalled;
@property (assign, getter = isElements10Installed) BOOL elements10Installed;
@property (assign, getter = isElements10PluginInstalled) BOOL elements10PluginInstalled;
@property (assign, getter = isElements11Installed) BOOL elements11Installed;
@property (assign, getter = isElements11PluginInstalled) BOOL elements11PluginInstalled;
@property (assign, getter = isElementsInstalled) BOOL elementsInstalled;
@property (assign, getter = isElementsPluginInstalled) BOOL elementsPluginInstalled;

@property (strong) NSMutableSet *photoshopAppPaths;

@property (strong, readonly) NSString *pluginsFolderPath;
@property (strong, readonly) NSString *MPApplicationSupportFolderPath;

@property (nonatomic, strong, readonly) NSSet *elementsVersions;

@property (retain) NSString *currentOperationName;

@property (assign, getter = isPhotoshopInstallationExecuting) BOOL photoshopInstallationExecuting;
@property (assign, getter = isLightroomInstallationExecuting) BOOL lightroomInstallationExecuting;
@property (assign, getter = isApertureInstallationExecuting) BOOL apertureInstallationExecuting;
@property (assign, getter = isElementsInstallationExecuting) BOOL elementsInstallationExecuting;

@property (nonatomic, strong) NSString *applicationName;
@property (nonatomic, strong) NSString *pluginAppName;
@property (nonatomic, strong) NSString *applicationUUID;
@property (nonatomic, strong) NSBundle *applicationBundle;

@property (nonatomic, assign) BOOL noNeedAppPluginIsRunningAlert;

+ (id)sharedInstaller;
- (instancetype)initWithPluginAppName:(NSString *)pluginAppName applicationName:(NSString *)applicationName applicationUUID:(NSString *)applicationUUID applicationBundle:(NSBundle *)applicationBundle;

- (void)validatePhotoshopInstallStatus;
- (void)validatePhotoshopInstallStatusAsync;
- (BOOL)isPhotoshopPluginNeedUpdate;
- (void)reinstallPhotoshopPlugin;
- (void)validateLightroomInstallStatus;
- (void)validateLightroomInstallStatusAsync;
- (BOOL)isLightroomPluginNeedUpdate;
- (void)reinstallLightroomPlugin;
- (NSString *)generateLightroomPluginContnets;
- (void)validateApertureInstallStatus;
- (void)validateApertureInstallStatusAsync;
- (BOOL)isAperturePluginNeedUpdate;
- (void)reinstallAperturePlugin;
- (void)validateElements10InstallStatus;
- (void)reinstallElements10Plugin;
- (void)validateElements11InstallStatus;
- (void)reinstallElements11Plugin;
- (void)validateElementsInstallStatusForVersion:(NSString *)aVersion;
- (void)validateElementsInstallStatus;
- (void)validateElementsInstallStatusAsync;
- (BOOL)isElementsPluginNeedUpdate;
- (void)reinstallElementsPluginForVersion:(NSString *)aVersion;
- (void)reinstallElementsPlugin;
- (void)installElementsPluginForVersion:(NSString *)aVersion;
- (BOOL)forceUninstallElementsPlugin;
- (void)installElementsPlugin;
- (BOOL)checkIFApplicationWithBundleIDIsRunning:(NSString *)anID;
- (BOOL)checkIFApplicationRunningWithBundleID:(NSString *)anID version:(NSString *)aVersion;
- (void)showAlertAboutApplicationIsRunning:(NSString *)anApplicationName forHostApplication:(NSString*)hostApplication;
- (void)showAlertAboutApplicationIsRunning:(NSString *)anApplicationName;

- (NSString *)photoshopLightroomPluginPath;
- (NSString *)aperturePluginPath;

- (NSArray *)pathsForAppsWithBundleID:(NSString *)anID version:(NSString *)aVersion;
- (NSArray *)pathsForAppsWithBundleID:(NSString *)anID versions:(NSSet *)aVersions;
- (NSArray *)elements10Paths;
- (NSArray *)elements11Paths;

- (BOOL)removeItemAtPath:(NSString *)aPath;
- (void)createFolderAtPath:(NSString *)aPath;
- (void)copyItemAtPath:(NSString *)aSrcPath toPath:(NSString *)aDstPath;
- (void)copyLinkForItemAtPath:(NSString *)aSrcPath toPath:(NSString *)aDstPath;

- (NSString *)versionForBundle:(NSBundle *)aBundle;

- (NSArray *)findAppsWithBundleID:(NSString *)anID;

- (NSArray *)findPackagesAtURL:(NSURL *)anURL withDepth:(NSUInteger)aDepth;

- (BOOL)pluginsNeedUpdateAtAppSupportMPDir;

- (void)checkAndUpdatePluginsAsync;
- (void)checkAndUpdatePluginsAsyncWithCompletionBlock:(void(^)(void))completionBlock;
- (void)checkAndUpdatePlugins;
- (void)checkAndUpdatePluginWithName:(NSString *)aName;
- (void)checkAndUpdateLightroomPlugin;

- (NSString *)pluginsFolderPath;

- (BOOL)forceUninstallPhotoshopPlugin;
- (void)installPhotoshopPlugin;

- (BOOL)forceUninstallLightroomPlugin;
- (void)installLightroomPlugin;

- (BOOL)forceUninstallAperturePlugin;
- (void)installAperturePlugin;

- (BOOL)checkIfPhotoshopRunning;
- (BOOL)checkIfLightroomRunning;
- (BOOL)checkIfApertureRunning;
- (BOOL)checkIfElementsRunning;

@end
