//
//  MPSPopUpButton.h
//  MPServices
//
//  Created by Oleksii Dykan on 6/22/15.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import "MPAbstractButton.h"

@protocol MPSPopUpButton <NSObject>
@property (readonly, nonatomic, assign) NSInteger selectedTag;
- (BOOL)selectItemWithTag:(NSInteger)tag;

- (void)addItemsWithTitles:(NSArray *)itemTitles;
- (void)removeAllItems;
@end


@interface MPSPopUpButton : MPAbstractButton <MPSPopUpButton>

@property (nonatomic, strong) IBOutlet NSMenu *popUpMenu;

@property (readonly, nonatomic, assign) NSInteger indexOfSelectedItem;
@property (readonly, nonatomic, assign) NSInteger numberOfItems;
@property (readonly, nonatomic, strong) NSMenuItem *selectedItem;

- (void)selectItemAtIndex:(NSInteger)index;
- (void)addItemWithTitle:(NSString *)title;

@end
