//
//  MPSRegUtils.h
//  Phoenix
//
//  Created by Andrey Shekhovtsov on 9/2/16.
//  Copyright © 2016 MacPhun LLC. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MPSubscriptionConsts.h"

typedef void(^MPSRegUtilsCallback)(BOOL success, NSDate *expirationDate);

@interface MPSRegUtils : NSObject

// ************** API Methods ****************
+ (void)validateWithResponseBody:(NSDictionary *)responseBody bundleId:(NSString *)bundleId completionHandler:(MPSRegUtilsCallback)completionHandler;
+ (void)getUserInfoWithBundleId:(NSString *)bundleId completionHandler:(MPSRegUtilsCallback)completionHandler;

+ (void)logout;
+ (void)logoutWithBundleId:(NSString *)bundleId;

// **************** Online | Offline  Check ******************
+ (void)onlineValidationCompletionHandler:(void(^)(BOOL result))completion;

+ (BOOL)offlineValidation;
+ (BOOL)offlineUserDateValidation;
+ (BOOL)offlineUserStatusValidation;

+ (void)check:(NSInteger)randomtime; // TODO: make define from this method

// **************** User Data ******************
+ (BOOL)isLogin;
+ (MPSubscriptionStatus)userStatus;
+ (NSInteger)trialDaysLeft;
+ (NSInteger)subscriptionDaysLeft;
+ (BOOL)activationAllowed;

// ****************  Helpers  **********************
+ (NSUserDefaults *)userDefaults;
+ (NSString *)token;
+ (NSString *)harwareUUID;

@end
