//
//  MPNewSliderCell.h
//  slider
//
//  Created by Alexey Voitenko on 20.01.16.
//  Copyright © 2016 macphun. All rights reserved.
//


#import <Cocoa/Cocoa.h>

#import "MPSSliderView.h"


@protocol MPSSliderViewDelegate;


@interface MPSSliderCell : NSSliderCell <MPSSliderViewDelegate>

@property (nonatomic) CGFloat defaultValue;

/*!
 * @brief value for drawing the bar fill value's line from. Should be between min and max values.
 */
@property (strong, nonatomic) NSNumber *fillValueFrom;

/*
 knobImage - image of the knob
 depends on slider control size it should have the next size:
 NSRegularControlSize:   21x21
 NSSmallControlSize:     15x15
 NSMiniControlSize:
 */
@property (strong, nonatomic) NSImage *knobImage;
@property (strong, nonatomic) NSImage *knobHighlightedImage;

/*
 There may be to types of the slider:
 Progress slider -
 slider should looks like the video player progress slider or volume slider
 so it draws different bar fill before the knob (barFillBeforeKnobImage)
 and after it (barFillImage)
 Standard slider -
 slider looks like just a simple slider with one fill (barFillImage)
 */
@property (strong, nonatomic) NSImage *barFillValueImage;
@property (strong, nonatomic) NSImage *barFillHighlitedImage;

/*
 Slider also has the ages so you should set
 the different images for the left and the right one
 */
@property (strong, nonatomic) NSImage *barLeftAgeImage;
@property (strong, nonatomic) NSImage *barHighlitedLeftAgeImage;

@property (strong, nonatomic) NSImage *barRightAgeImage;
@property (strong, nonatomic) NSImage *barHighlitedRightAgeImage;

/*!
 * @brief name for images that will be used as three part image for drawing background of bar (will be suffixed with _left, _center and _right)
 */
@property (copy, nonatomic) NSString *barBackThreePartImageName;
@property (copy, nonatomic) NSString *barBackHightlightedThreePartImageName;

/*!
 * @brief name for images that will be used as three part image for filling value line (will be suffixed with _left, _center and _right)
 */
@property (copy, nonatomic) NSString *barFillValueThreePartImageName;
@property (copy, nonatomic) NSString *barFillValueHightlightedThreePartImageName;


@property (copy, nonatomic) NSString *barMaskImageName;

@property (assign, nonatomic) BOOL showKnobOnMouseInside;
@property (assign, nonatomic) BOOL valueFillEnabled;
@property (nonatomic) BOOL narrowKnobClickRect;

@property (nonatomic, strong) NSArray<NSColor *> *gradientColors;
@property (nonatomic, strong) NSArray<NSNumber *> *gradientColorsPositions;

@property (copy, nonatomic)  NSImage *centerMarkImage;

/*
 Return LADSlider with custom knob and standard NSSlider bar
 If the argument is nil
 the method will return nil
 */
- (id)initWithKnobImage:(NSImage *)knob;

/*
 Return LADSlider with custom knob and tack
 isProgressType == NO
 If the one of the followings arguments is nil
 the method will return nil
 */
- (id)initWithKnobImage:(NSImage *)knob barFillImage:(NSImage *)barFill
        barLeftAgeImage:(NSImage *)barLeftAge andbarRightAgeImage:(NSImage *)barRightAge;

/*
 Return LADSlider with custom knob and bar
 isProgressType == YES
 If the one of the followings arguments is nil
 the method will return nil
 */
- (id)initWithKnobImage:(NSImage *)knob barFillImage:(NSImage *)barFill
  barFillHighlitedImage:(NSImage *)barFillHighlited
        barLeftAgeImage:(NSImage *)barLeftAge barRightAgeImage:(NSImage *)barRightAge;

/*!
 * @description Determines if location point of current mouse event is inside of knob rect
 * @param event Current mouse event
 * @return returns YES if location is inside, NO - otherwise
 */
- (BOOL)isEventLocationInKnobRect:(NSEvent *)event;

@property (nonatomic, copy) void (^sliderDidEndChangingValueBlock)();

@end
