//
//  MPSessionManager.h
//  MPServices
//
//  Created by vladislav.senyukov on 5/4/17.
//  Copyright © 2017 MacPhun. All rights reserved.
//

#import "MPSignaturedManager.h"
#import "MPSession.h"

static NSString *const MPSessionDeepLinkDidReceiveNotification = @"MPSessionDeepLinkDidReceiveNotification";
static NSString *const MPSessionDidSetNotification = @"MPSessionDidSetNotification";

@interface MPSessionManager : MPSignaturedManager
- (void)updateWithAuthDic:(NSDictionary*)authDic;
- (void)clearCurrentSession;
- (void)decrementPhotosCount:(NSUInteger)photosCount;
- (void)setupFBLoginObserver;
- (NSDictionary*)decodeResponseDic:(NSDictionary*)encodedDic;
@property (nonatomic, readonly) MPSession *session;
@property (nonatomic, strong) NSDictionary *debugInfo;
@property (nonatomic, strong) NSString *lastDeepLinkReceived;
@end
