//
//  MPWebConsts.h
//  MPServices
//
//  Created by vladislav.senyukov on 5/4/17.
//  Copyright © 2017 MacPhun. All rights reserved.
//

#ifndef MPSubscriptionConsts_h
#define MPSubscriptionConsts_h

// SESSION
#define kMPSubscriptionSuccessResponse          @"success"
#define kMPSubscriptionAuthData                 @"auth_data"
#define kMPSubscriptionAuthToken                @"auth_token"
#define kMPSubscriptionSignature                @"signature"
#define kMPSubscriptionBody                     @"body"
#define kMPSubscriptionData                     @"data"

// USER
#define kMPSubscriptionUserKey                  @"user"
#define kMPSubscriptionUserFirstName            @"first_name"
#define kMPSubscriptionUserLastName             @"last_name"
#define kMPSubscriptionUserEmail                @"email"
#define kMPSubscriptionAvatar                   @"avatar"
#define kMPSubscriptionPhotosLeft               @"photos_left"

// SUBSCRIPTION
#define kMPSubscriptionKey                      @"subscription"
#define kMPSubscriptionStatus                   @"subscribe_status"
#define kMPSubscriptionEventTime                @"event_time"
#define kMPSubscriptionExpiredTime              @"expired_time"
#define kMPSubscriptionNextBillDate             @"next_bill_date"
#define kMPSubscriptionActivationAllowed        @"activation_allowed"
#define kMPSubscriptionDaysLeft                 @"days_left"
#define kMPSubscriptionStartPeriodDate          @"start_period_date"

// SUBSCRIPTION_PLAN
#define kMPSubscriptionPlanKey                  @"subscription_plan"
#define kMPSubscriptionPlanName                 @"name"
#define kMPSubscriptionPlanPriority             @"priority"
#define kMPSubscriptionBatchMaxCount            @"batch_max_count"
#define kMPSubscriptionImagesPerMonth           @"images_per_month"
#define kMPSubscriptionRawProcessingAllowed     @"raw_processing_allowed"
#define kMPSubscriptionComputersCount           @"computers_count"

// Defaults keys
#define kMPSubscriptionLastSessionDate              @"kMPSubscriptionLastSessionDate"
#define kMPSubscriptionMonthTimerStartDate          @"kMPSubscriptionMonthTimerStart"
#define kMPSubscriptionLastPhotosCounterResetDate   @"kMPSubscriptionLastPhotosCounterResetDate"

typedef NS_ENUM(NSUInteger, MPSubscriptionStatus) {
    MPSubscriptionStatus_Inactive = 0,
    MPSubscriptionStatus_Trialing,
    MPSubscriptionStatus_Active,
    MPSubscriptionStatus_PastDue
};

typedef NS_ENUM(NSUInteger, MPSubscriptionErrorStatus) {
    MPSubscriptionErrorStatus_None = 0,
    MPSubscriptionErrorStatus_TrialExpired,
    MPSubscriptionErrorStatus_ActivationDisallowed,
    MPSubscriptionErrorStatus_DateCheat,
    MPSubscriptionErrorStatus_ErrorResponse,
};

typedef NS_ENUM(NSUInteger, MPSubscriptionErrorType) {
    MPSubscriptionErrorType_RawsDisallowed,
    MPSubscriptionErrorType_BatchLimitReached,
    MPSubscriptionErrorType_PhotosPerMonthLimitReached,
};

static NSString *const MPSubscriptionErrorCountKey = @"MPSubscriptionErrorCountKey";

@class MPSubscriptionError;

typedef void(^MPSubscriptionSessionCreatedHandler)(MPSubscriptionErrorStatus error);
typedef void(^MPSubscriptionSessionValidatedWithErrorHandler)(BOOL success, MPSubscriptionErrorStatus error);

#define kMPSecondsInDay                         (24 * 60 * 60)
#define kMPNumberOfMonthsToResetCounter         1
#define MPAppSubstituteFakeResponses            0

#endif /* MPWebConsts_h */
