//
//  MPSuperMenuItem.h
//  MPServices
//
//  Created by Kirill Kovalenko on 6/9/16.
//  Copyright © 2016 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MPSuperMenuItemSettings.h"

@class MPSuperMenu;

@interface MPSuperMenuItem : NSViewController <NSValidatedUserInterfaceItem>

#pragma mark -
#pragma mark Properties

/* Returns parent menu. */
@property (nullable, weak) MPSuperMenu *parentMenu;

/* Returns submenu. */
@property (nonatomic, strong, nullable) MPSuperMenu *submenu;

/* Returns presence submenu. */
@property (readonly) BOOL hasSubmenu;

/* Returns the MPSuperMenuItem whose submenu contains the receiver, or nil if the receiver does not have a parent item. */
@property (nullable, readonly, weak) MPSuperMenuItem *parentItem;

/* Returns information whether the item is separator or not. */
@property (getter=isSeparatorItem, readonly) BOOL separatorItem;

@property (copy, nonnull) NSString *keyEquivalent;
@property NSEventModifierFlags keyEquivalentModifierMask;

/* Returns title cell. */
@property (nullable, copy) NSString *label;

/* Set and get image item. */
@property (nonatomic, nullable, strong) NSImage *image;

/* Set and get selected image */
@property (nullable, strong) NSImage *selectedImage;

/* Property for action. */
@property (nullable, weak) id target;
@property (nullable) SEL action;

@property NSInteger tag;

/* Setting for state. */
@property (nonatomic, assign) NSInteger state;

@property (nonatomic, strong, nullable) NSImage *onStateImage;
@property (nonatomic, strong, nullable) NSImage *highlightStateImage;
@property (nonatomic, strong, nullable) NSImage *offStateImage;

/* Set and get highlight state. */
@property (nonatomic, assign, getter=isHighlighted) BOOL highlighted;

/* Set and get state about submenu. */
@property (assign, getter=isOpenedSubmenu) BOOL openedSubmenu;

/* Callback call when item selected. */
@property (nonatomic, copy, nullable) void (^selectedCallback)();

/* Custom settings item. */
@property (nonatomic, strong, nullable) MPSuperMenuItemSettings *settings;

/*!
 * @brief should localize title or not. YES by default.
 */
@property (assign, nonatomic) IBInspectable BOOL localized;


#pragma mark -
#pragma mark Methods

- (nullable id)initWithTitle:(NSString * _Nullable)aString action:(SEL _Nullable)aSelector keyEquivalent:(NSString *_Nullable)keyEquivalent;
- (nullable id)initWithTitle:(NSString * _Nullable)aString action:(SEL _Nullable)aSelector keyEquivalent:(NSString *_Nullable)keyEquivalent localized:(BOOL)localized;
- (nullable id)initWithTitle:(NSString * _Nullable)aString favicon:(NSImage * _Nullable)image withSelector:(SEL _Nullable)aSelector withTarget:(id _Nullable)aTarget __attribute__((deprecated("use initWithTitle:image:selector:target:")));
- (nullable id)initWithTitle:(NSString * _Nullable)aString image:(NSImage * _Nullable)image selector:(SEL _Nullable)aSelector target:(id _Nullable)aTarget;

- (nullable id)initWithTitle:(NSString * _Nullable)aString withSelector:(SEL _Nullable)aSelector withTarget:(id _Nullable)aTarget;

+ (MPSuperMenuItem * _Nonnull)separatorItem;
+ (MPSuperMenuItem * _Nonnull)titleItemWithName:(NSString * _Nonnull)name;

- (void)sendAction;

- (void)itemEntered:(BOOL)status;

@end
