//
//  NSArray+ObjectMapper.h
//  MPServices
//
//  Created by Andrey Shekhovtsov on 5/19/17.
//  Copyright © 2017 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSArray (ObjectMapper)

/**
 * @abstract Converts NSArray<NSURL*> to NSArray<NSString*> by applying -[NSURL path] to each entity.
 */
- (NSArray <NSString *> *)pathsArray;

/**
 * @abstract Converts NSArray<NSString*> to NSArray<NSURL*> by applying [[NSURL alloc] initWithString:] to each entity.
 */
- (NSArray <NSURL *> *)URLsArray;

- (NSArray *)map:(id (^)(id inputObject))mapper;

/**
 * @abstract Converts an array by applying a pattern described in block to each entity. If insertPlaceholders is YES then all failed to map objects will be replaced with [NSNull null] object, otherwise it'll skip them and a result array count of objects is gonna be less than initial count of objects.
 */
- (NSArray *)map:(id (^)(id obj))block insertPlaceholders:(BOOL)insertPlaceholders;

@end
