//
//  NSBezierPath+Additions.h
//  MPServices
//
//  Created by Oleksii Dykan on 8/5/15.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>


typedef NS_OPTIONS(NSUInteger, MPBezierPathCorner) {
    MPBezierPathCornerBottomLeft    = 1 << 0,
    MPBezierPathCornerBottomRight   = 1 << 1,
    MPBezierPathCornerTopLeft       = 1 << 2,
    MPBezierPathCornerTopRight      = 1 << 3,
    MPBezierPathCornerAll           = (MPBezierPathCornerBottomLeft | MPBezierPathCornerBottomRight | MPBezierPathCornerTopLeft | MPBezierPathCornerTopRight),
};

typedef struct {
    CGFloat topLeft;
    CGFloat topRight;
    CGFloat bottomRight;
    CGFloat bottomLeft;
} MPSCornerRadii;

static const MPSCornerRadii MPSZeroCornerRadii = {};
MPSCornerRadii MPSMakeCornerRadii(CGFloat topLeft, CGFloat topRight, CGFloat bottomRight, CGFloat bottomLeft);
BOOL MPSCornerRadiiIsEqual(MPSCornerRadii r1, MPSCornerRadii r2);

@interface NSBezierPath (Additions)

+ (NSBezierPath *)bezierPathWithRect:(NSRect)rect cornerRadii:(MPSCornerRadii)radii roundedCorners:(MPBezierPathCorner)corners;
+ (NSBezierPath *)bezierPathWithRect:(NSRect)rect cornerRadius:(CGFloat)cornerRadius roundedCorners:(MPBezierPathCorner)corners;

- (CGPathRef)quartzPath;

@end
