//
//  NSColor+Additions.h
//  MPServices
//
//  Created by Oleksii Dykan on 2/19/15.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#define RGB(r,g,b) ([NSColor colorWithRed:r/255.f green:g/255.f blue:b/255.f alpha:1])
#define CalibratedRGB(r,g,b) ([NSColor colorWithCalibratedRed:r/255.f green:g/255.f blue:b/255.f alpha:1])
#define RGBA(r,g,b,a) ([NSColor colorWithRed:r/255.f green:g/255.f blue:b/255.f alpha:a])
#define CalibratedRGBA(r,g,b,a) ([NSColor colorWithCalibratedRed:r/255.f green:g/255.f blue:b/255.f alpha:a])
#define White(color) (RGB(color,color,color))
#define WhiteA(color,a) (RGBA(color,color,color,a))

@interface NSColor (Additions)

+ (id)mpColorWithRed:(CGFloat)red green:(CGFloat)green blue:(CGFloat)blue alpha:(CGFloat)alpha;
+ (instancetype)mpColorWithHEXString:(NSString *)hexString;
+ (instancetype)mpColorWithCalibratedHEXString:(NSString *)hexString;
+ (instancetype)mpColorWithCalibratedHEXString:(NSString *)hexString alpha:(CGFloat)alpha;

+ (instancetype)colorFromGradient:(NSGradient *)gradient;

@end
